#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct pointin3d {
    double x, y, z;
} PT;

#define MD 15

void drtr(PT P, PT Q, PT R)
{
	printf("connect %f %f %f %f %f %f %f %f\n", P.x / P.z, P.y / P.z, Q.x / Q.z, Q.y / Q.z, R.x / R.z, R.y / R.z, P.x / P.z, P.y / P.z);
	return;
}

void triangle(PT P, PT Q, PT R, int d, int or)
{
	PT P2, Q2, R2;

	drtr(P, Q, R);
	if(d >= MD) return;
	d++;
	if(or != 1) {
		P2.x = 2 * Q.x + R.x - P.x; P2.y = 2 * Q.y + R.y - P.y; P2.z = 2 * Q.z + R.z - P.z;
		triangle(P2, Q, R, d, 1);
	}
	if(or != 2) {
		Q2.x = 2 * R.x + P.x - Q.x; Q2.y = 2 * R.y + P.y - Q.y; Q2.z = 2 * R.z + P.z - Q.z;
		triangle(P, Q2, R, d, 2);
	}
	if(or != 3) {
		R2.x = 2 * P.x + Q.x - R.x; R2.y = 2 * P.y + Q.y - R.y; R2.z = 2 * P.z + Q.z - R.z;
		triangle(P, Q, R2, d, 3);
	}
	return;
}

	
int main(int argc, char *argv[])
{
	PT P, Q, R;

	if(argc > 9) {
		P.x = atof(argv[1]);
		P.y = atof(argv[2]);
		P.z = atof(argv[3]);
		Q.x = atof(argv[4]);
		Q.y = atof(argv[5]);
		Q.z = atof(argv[6]);
		R.x = atof(argv[7]);
		R.y = atof(argv[8]);
		R.z = atof(argv[9]);
	}
	else {
		P.z = Q.z = R.z = 1.;
		P.x = 1.0; P.y = 0.;
		Q.x = -0.5; Q.y = 0.5 * sqrt(3.);
		R.x = Q.x; R.y = -Q.y;
		/*	P.x = P.y = Q.x = R.z = 1.;
			Q.y = R.x = R.y = 0.;
			P.z = 3.; Q.z = 2.5;
		*/
	}
	triangle(P, Q, R, 1, 0);
	printf("circle 0 0 .01\ncolor 3 0 0\ncircle 0 0 1.5\n");
	return 0;
}
