#include "planegeometry.h"
#include <math.h>

void drtangents(CIRC c, POINT P)
{
	POINT Q;
	double x10, y10, r2, A, B, C;

	x10 = c.c.x - P.x;
	y10 = c.c.y - P.y;
	r2 = c.r * c.r;
	A = x10 * x10 + y10 * y10;
	B = x10 * r2;
	C = r2 * (r2 - y10 * y10);
	Q.x = (-B + sqrt(B * B - A * C)) / A + c.c.x;
	Q.y = -(x10 * (Q.x - c.c.x) + r2) / y10 + c.c.y;
	WRITE(Q, P);
	Q.x = (-B - sqrt(B * B - A * C)) / A + c.c.x;
	Q.y = -(x10 * (Q.x - c.c.x) + r2) / y10 + c.c.y;
	WRITE(Q, P);
}

POINT ctsim1(CIRC c1, CIRC c2)
{
	POINT P;

	P.x = (c1.r * c2.c.x - c2.r * c1.c.x) / (c1.r - c2.r);
	P.y = (c1.r * c2.c.y - c2.r * c1.c.y) / (c1.r - c2.r);
	return P;
}

POINT ctsim2(CIRC c1, CIRC c2)
{
	POINT P;

	P.x = (c1.r * c2.c.x + c2.r * c1.c.x) / (c1.r + c2.r);
	P.y = (c1.r * c2.c.y + c2.r * c1.c.y) / (c1.r + c2.r);
	return P;
}

int main(int argc, char *argv[])
{
	CIRC c1, c2, c3;
	POINT P12, P23, P31, Q12, Q23, Q31;

	c1.c.x = -3.; c1.c.y = 0.5; c1.r = 2.5;
	c2.c.x = 3.8; c2.c.y = 2.1; c2.r = 1.5;
	c3.c.x = 2.; c3.c.y = -2.; c3.r = 1.;
	WRITE(c1);
	WRITE(c2);
	WRITE(c3);
	printf("color 0 0 3\n");
	P12 = ctsim1(c1, c2);
	drtangents(c1, P12); drtangents(c2, P12);
	P23 = ctsim1(c2, c3);
	drtangents(c2, P23); drtangents(c3, P23);
	P31 = ctsim1(c1, c3);
	drtangents(c1, P31); drtangents(c3, P31);
	printf("color 3 0 0\n");
	WRITE(P12 * P23);
	printf("color 0 3 1\n");
	Q12 = ctsim2(c1, c2);
	Q23 = ctsim2(c3, c2);
	Q31 = ctsim2(c3, c1);
	drtangents(c1, Q12); drtangents(c2, Q12);
	drtangents(c2, Q23); drtangents(c3, Q23);
	drtangents(c3, Q31); drtangents(c1, Q31);
	printf("color 3 2 0\n");
	WRITE(Q12 * Q23);	
	WRITE(Q31 * Q23);
	WRITE(Q31 * Q12);
	printf("gray 0.5\n");
	WRITE(c1.c, Q23);
	WRITE(c2.c, Q31);
	WRITE(c3.c, Q12);
	return 0;
}
