#include "planegeometry.h"
#include <math.h>

double hsq3 = sqrt(3.) / 2.;

POINT vtrt(POINT P1, POINT P2, POINT P3)
{
	POINT P0, Q;

	P0.x = (P1.x + P2.x) / 2.;
	P0.y = (P1.y + P2.y) / 2.;
	if((P1.y - P2.y) * P3.x + (P2.x - P1.x) * P1.y > P2.x * P1.y - P1.x * P2.y) {
		Q.x = P0.x + hsq3 * (P2.y - P1.y);
		Q.y = P0.y + hsq3 * (P1.x - P2.x);
	}
	else {
		Q.x = P0.x + hsq3 * (P1.y - P2.y);
		Q.y = P0.y + hsq3 * (P2.x - P1.x);
	}
	return Q;
}
		
POINT ctoftr(POINT P1, POINT P2, POINT P3)
{
	POINT Q;

	Q.x = (P1.x + P2.x + P3.x) / 3.;
	Q.y = (P1.y + P2.y + P3.y) / 3.;
	return Q;
}

int main(int argc, char *argv[])
{
	POINT A, B, C, D, E, F, L, M, N;

	A.x = 3.; A.y = 0.;
	B.x = -4.; B.y = 0.;
	C.x = 4.; C.y = 3.5;
	WRITE(A, B, C);
	D = vtrt(B, C, A);
	WRITE(D, B, C);
	E = vtrt(C, A, B);
	WRITE(A, E, C);
	F = vtrt(A, B, C);
	WRITE(A, B, F);
	printf("color 0 0 3\n");
	WRITE(A, D);
	WRITE(B, E);
	WRITE(C, F);
	printf("color 3 0 0\n");
	L = ctoftr(D, B, C);
	M = ctoftr(A, E, C);
	N = ctoftr(A, B, F);
	WRITE(L, M, N);
	return 0;
}
