#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct pointin2d {
    double x, y;
} POINT;

int md = 2;

void drawt(POINT A, POINT B, POINT C)
{
	printf("connect %f %f %f %f %f %f %f %f\n", A.x, A.y, B.x, B.y, C.x, C.y, A.x, A.y);
}

void hanten(POINT A, POINT B, POINT C, int d, int e)
{
	POINT D;

	drawt(A, B, C);
	if(d == md) return;
	d++;
	if(e != 1) {
		D.x = B.x + C.x - A.x;
		D.y = B.y + C.y - A.y;
		hanten(D, B, C, d, 1);
	}
	if(e != 2) {
		D.x = 2. * A.x - B.x;
		D.y = 2. * A.y - B.y;
		hanten(A, D, C, d, 2);
	}
	if(e != 3) {
		D.x = 2. * A.x - C.x;
		D.y = 2. * A.y - C.y;
		hanten(A, B, D, d, 3);
	}
	return;
}


int main(int argc, char *argv[])
{
	POINT A, B, C;

	if(argc > 1) md = atoi(argv[1]);
	A.x = A.y = B.y = C.x = 0.;
	B.x = C.y = 1.;
	drawt(A, B, C);
	hanten(A, B, C, 0, 0);
	return 0;
}
