#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[])
{
	double t, dt = .01, x, y, x0, y0 = 0., r, sq3 = sqrt(3.);

	for(x0 = 1. / sq3, t = dt; t < M_PI / 3.; t += dt) {
		r = 1. / (sq3 * cos(t) + sin(t));
		x = r * cos(t);
		y = r * sin(t);
		printf("connect %f %f %f %f\n", x0, y0, x, y);
		x0 = x; y0 = y;
	}
	for(; t < 2. * M_PI / 3.; t += dt) {
		r = 1. / (2. * sin(t));
		x = r * cos(t);
		y = r * sin(t);
		printf("connect %f %f %f %f\n", x0, y0, x, y);
		x0 = x; y0 = y;
	}
	return 0;
}
