#include <stdio.h>
#include <stdlib.h>
#include "spacegeometry.h"

POINT isof3pl(Plane u, Plane v, Plane w)
{
	POINT p;
	double d;

	d = u.a * v.b * w.c + u.b * v.c * w.a + u.c * v.a * w.b - u.a * v.c * w.b - u.c * v.b * w.a - u.b * v.a * w.c;
	p.x = (u.d * v.b * w.c + u.b * v.c * w.d + u.c * v.d * w.b - u.d * v.c * w.b - u.c * v.b * w.d - u.b * v.d * w.c) / d;
	p.y = (u.a * v.d * w.c + u.d * v.c * w.a + u.c * v.a * w.d - u.a * v.c * w.d - u.c * v.d * w.a - u.d * v.a * w.c) / d;
	p.z = (u.a * v.b * w.d + u.b * v.d * w.a + u.d * v.a * w.b - u.a * v.d * w.b - u.d * v.b * w.a - u.b * v.a * w.d) / d;
	return p;
}

Plane pl3pts(POINT a, POINT b, POINT c)
{
	Plane h;

	h.a = a.y * b.z + b.y * c.z + c.y * a.z - a.y * c.z - b.y * a.z - c.y * b.z;
	h.b = a.z * b.x + b.z * c.x + c.z * a.x - a.z * c.x - b.z * a.x - c.z * b.x;
	h.c = a.x * b.y + b.x * c.y + c.x * a.y - a.x * c.y - b.x * a.y - c.x * b.y;
	h.d = a.x * b.y * c.z + b.x * c.y * a.z + c.x * a.y * b.z - a.x * c.y * b.z - b.x * a.y * c.z - c.x * b.y * a.z;
	return h;
}

POINT circumct(POINT p, POINT q, POINT r)
{
	Plane u, v, w;
	//	POINT ct;

	u = pl3pts(p, q, r);
	v.a = p.x - q.x; v.b = p.y - q.y; v.c = p.z - q.z;
	v.d = (p.x * p.x - q.x * q.x + p.y * p.y - q.y * q.y + p.z * p.z - q.z * q.z) / 2.;
	w.a = p.x - r.x; w.b = p.y - r.y; w.c = p.z - r.z;
	w.d = (p.x * p.x - r.x * r.x + p.y * p.y - r.y * r.y + p.z * p.z - r.z * r.z) / 2.;
	return isof3pl(u, v, w);
}

int main(int argc, char *argv[])
{
	POINT u, v, w, x;

	if(argc < 10) return 0;
	u.x = atof(argv[1]);
	u.y = atof(argv[2]);
	u.z = atof(argv[3]);
	v.x = atof(argv[4]);
	v.y = atof(argv[5]);
	v.z = atof(argv[6]);
	w.x = atof(argv[7]);
	w.y = atof(argv[8]);
	w.z = atof(argv[9]);
	x = circumct(u, v, w);
	printf("(%f, %f, %f)\n", x.x, x.y, x.z);
	printf("ux = %f, vx = %f wx = %f\n", (u - x) * (u - x), (v - x) * (v - x), (w - x) * (w - x));
	return 0;
}

