#include <stdio.h>
#include <stdlib.h>
#include "spacegeometry.h"

POINT isof3pl(Plane u, Plane v, Plane w)
{
	POINT p;
	double d;

	d = u.a * v.b * w.c + u.b * v.c * w.a + u.c * v.a * w.b - u.a * v.c * w.b - u.c * v.b * w.a - u.b * v.a * w.c;
	p.x = (u.d * v.b * w.c + u.b * v.c * w.d + u.c * v.d * w.b - u.d * v.c * w.b - u.c * v.b * w.d - u.b * v.d * w.c) / d;
	p.y = (u.a * v.d * w.c + u.d * v.c * w.a + u.c * v.a * w.d - u.a * v.c * w.d - u.c * v.d * w.a - u.d * v.a * w.c) / d;
	p.z = (u.a * v.b * w.d + u.b * v.d * w.a + u.d * v.a * w.b - u.a * v.d * w.b - u.d * v.b * w.a - u.b * v.a * w.d) / d;
	return p;
}

POINT circumctoftetra(POINT a, POINT b, POINT c, POINT d)
{
	return isof3pl(a | b, a | c, a | d);
}

int main(int argc, char *argv[])
{
	POINT a, b, c, d, g;
	Plane h;

	if(argc < 13) return 0;
	a.x = atof(argv[1]);
	a.y = atof(argv[2]);
	a.z = atof(argv[3]);
	b.x = atof(argv[4]);
	b.y = atof(argv[5]);
	b.z = atof(argv[6]);
	c.x = atof(argv[7]);
	c.y = atof(argv[8]);
	c.z = atof(argv[9]);
	d.x = atof(argv[10]);
	d.y = atof(argv[11]);
	d.z = atof(argv[12]);
	g = circumctoftetra(a, b, c, d);
	printf("(%f, %f, %f)\n", g.x, g.y, g.z);
	h = b | c;
	printf("%f, ", h.a * g.x + h.b * g.y + h.c * g.z - h.d);
	h = b | d;
	printf("%f, ", h.a * g.x + h.b * g.y + h.c * g.z - h.d);
	h = d | c;
	printf("%f\n", h.a * g.x + h.b * g.y + h.c * g.z - h.d);
	return 0;
}
