#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MD 10

int a[6];
double sq3;

void draw(int v1[], int v2[], int v3[]){
	int i, *v;
	double d, x[3], y[3];

	for(i = 0; i < 3; i++) {
		if(i == 0) v = v1;
		else if(i == 1) v = v2;
		else v = v3;
		d = *v + v[1] + v[2];
		x[i] = sq3 * (v[1] - v[2]) / d;
		y[i] = (2. * *v - v[1] - v[2]) / d;
	}
	printf("connect %f %f %f %f %f %f %f %f\n", x[0], y[0], x[1], y[1], x[2], y[2], x[0], y[0]);
	return;
}

void ex(int v1[], int v2[], int v3[], int dir, int depth) {
	int v4[3], i, b, c;

	if(depth > MD) return;
	depth++;
	if(dir == 1) {
		b = a[0]; c = a[2];
		for(i = 0; i < 3; i++) v4[i] = b * v2[i] + c * v3[i] - v1[i];
		draw(v4, v2, v3);
		ex(v4, v2, v3, 2, depth);
		ex(v4, v2, v3, 3, depth);
	}
	if(dir == 2) {
		b = a[1]; c = a[5];
		for(i = 0; i < 3; i++) v4[i] = b * v1[i] + c * v3[i] - v2[i];
		draw(v1, v4, v3);
		ex(v1, v4, v3, 1, depth);
		ex(v1, v4, v3, 3, depth);
	}
	if(dir == 3) {
		b = a[3]; c = a[4];
		for(i = 0; i < 3; i++) v4[i] = b * v1[i] + c * v2[i] - v3[i];
		draw(v1, v2, v4);
		ex(v1, v2, v4, 1, depth);
		ex(v1, v2, v4, 2, depth);
	}
	return;
}

int main(int argc, char *argv[])
{
	int i, v1[3], v2[3], v3[3];

	if(argc < 7) {
		printf("6 parameters needed\n");
		return 0;
	}
	sq3 = sqrt(3.);
	for(i = 0; i < 6; i++) a[i] = atoi(argv[i + 1]);
	for(i = 0; i < 3; i++) v1[i] = v2[i] = v3[i] = 0;
	v1[0] = v2[1] = v3[2] = 1;
	draw(v1, v2, v3);
	ex(v1, v2, v3, 1, 0);
	ex(v1, v2, v3, 2, 0);
	ex(v1, v2, v3, 3, 0);
	return 0;
}
