#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    double r, i;
} CPX;
double abs(CPX z)
{
    return sqrt(z.r * z.r + z.i * z.i);
}
CPX operator -(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r - x1.r;
    y.i = x2.i - x1.i;
    return y;
}
CPX operator +(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r + x1.r;
    y.i = x2.i + x1.i;
    return y;
}
CPX operator /(CPX x, CPX y)
{
    CPX z;
    double w;

    w = y.r * y.r + y.i * y.i;
    z.r = (x.r * y.r + x.i * y.i) / w;
    z.i = (x.i * y.r - x.r * y.i) / w;
    return z;
}
CPX operator *(CPX x, CPX y)
{
    CPX z;

    z.r = x.r * y.r - x.i * y.i;
    z.i = x.r * y.i + x.i * y.r;
    return z;
}
CPX crossratio(CPX z1, CPX z2, CPX z3, CPX z4)
{
	return (z1 - z3) * (z2 - z4) / ((z1 - z4) * (z2 - z3));
}


int main(int argc, char *argv[])
{
	CPX z1, z2, z3, z4, z0;
	double a, b, d, s, zr;

	if(argc < 5) return 0;
	z1.r = atof(argv[1]);
	z1.i = atof(argv[2]);
	z2.r = atof(argv[3]);
	z2.i = atof(argv[4]);
	a = (z1.i - z2.i) / (z1.r - z2.r);
	b = (z1.r * z2.i - z1.i * z2.r) / (z1.r - z2.r);
	d = sqrt(a * a - b* b + 1.);
	z3.r = (-a * b + d) / (a * a + 1);
	z3.i = a * z3.r + b;
	z4.r = (-a * b - d) / (a * a + 1);
	z4.i = a * z4.r + b;
	printf("z3 = %f + i%f, z4 = %f + i%f\n", z3.r, z3.i, z4.r, z4.i);
	printf("%f, %f\n", abs(z3), abs(z4));
	z0 = crossratio(z1, z2, z3, z4);
	printf("%f + i%f\n", z0.r, z0.i);
	zr = z0.r;
	s = 1. + sqrt(1. - z1.r * z1.r - z1.i * z1.i);
	z1.r = z1.r / s; z1.i = z1.i / s;
	s = 1. + sqrt(1. - z2.r * z2.r - z2.i * z2.i);
	z2.r = z2.r / s; z2.i = z2.i / s;
	z0 = crossratio(z1, z2, z3, z4);
	printf("z1 = %f + i%f, z2 = %f + i%f\n", z1.r, z1.i, z2.r, z2.i);
	printf("%f + i%f\n", z0.r, z0.i);
	printf("%f = %f?\n", zr, z0.r * z0.r);
	return 0;
}
