#include "planegeometry.h"
#include <math.h>

int iang(POINT P, POINT Q)
{
	int d;

	d = 64 * 180 * atan2(P.y - Q.y, P.x - Q.x) / M_PI;
	return d;
}

int main(int argc, char *argv[])
{
	POINT A, B, C, D, E, F, G, H, I;
	double d, t, ct, st;
	int ag, agh;

	if(argc > 1) ag = atoi(argv[1]);
	else ag = 30;
	ct = cos(ag * M_PI / 180);
	st = sin(ag * M_PI / 180);
	A.x = B.x = ct; A.y = st; B.y = -st;
	C.x = D.x = -2. * ct; C.y = -2. * st; D.y = 2. * st;
	WRITE(A, C);
	WRITE(B, D);
	printf("circle %d %d 1 %d %d\n", 0, 0, -ag * 64, ag * 128);
	printf("circle %d %d 2 %d %d\n", 0, 0, (180 - ag) * 64, ag * 128);
	E.x = 0.5 * A.x; E.y = 0.5 * A.y;
	F.x = 0.75 * D.x; F.y = 0.75 * D.y;
	printf("color 0 0 3\n");
	WRITE(E, F);
	G = (A * C) * (E | F);
	WRITE(F, G);
	d = G + A;
	agh = iang(F, G);
	printf("circle %f %f %f %d %d\n", G.x, G.y, d, ag * 64, agh - ag * 64);
	d = F + D;
	t = agh * M_PI / (180 * 64);
	H.x = F.x + d * cos(t);
	H.y = F.y + d * sin(t);
	WRITE(F, H);
	printf("circle %f %f %f %d %d\n", F.x, F.y, d, agh, (180 - ag) * 64 - agh);
	d = C + G;
	t += M_PI;
	I.x = G.x + d * cos(t);
	I.y = G.y + d * sin(t);
	WRITE(G, I);
	printf("circle %f %f %f %d %d\n", G.x, G.y, d, (180 + ag) * 64, agh - ag * 64);
	d = F + B;
	printf("circle %f %f %f %d %d\n", F.x, F.y, d, agh + 180 * 64, (180 - ag) * 64 - agh);
	return 0;
}
