#include "planegeometry.h"
#include <math.h>

int iang(POINT P, POINT Q)
{
	int d;

	d = 64 * 180 * atan2(P.y - Q.y, P.x - Q.x) / M_PI;
	return d;
}

int main(int argc, char *argv[])
{
	POINT A, B, C, D, E, F, G;
	double d, t, ct, st, ct2, st2, a = 0.4, b = -0.5, r;
	int angl1, angl2;

	if(argc > 1) t = atof(argv[1]);
	else t = 1.;
	A.x = ct = cos(t); A.y = st = sin(t);
	B.x = ct2 = cos(M_PI - t); B.y = st2 = sin(M_PI - t);
	C.x = -A.x; C.y = -A.y; D.x = -B.x; D.y = -B.y;
	angl1 = 64 * 180 * t / M_PI;
	printf("color 0 0 3\ncircle 0 0 1\ngray 0.\n");
	WRITE(A,C); WRITE(B, D);
	printf("circle 0 0 1 %d %d\n", -angl1, 2 * angl1);
	printf("circle 0 0 1 %d %d\n", -angl1 + 64 * 180, 2 * angl1);
	E.x = a * A.x; E.y = a * A.y; F.x = a * B.x; F.y = a * B.y;
	G.x = 0.; G.y = b;
	WRITE(E, G); WRITE(F, G);
	angl2 = iang(E, G);
	printf("circle %f %f %f %d %d\n", E.x, E.y, 1. - a, angl1, angl2 - angl1);
	r = (E + G) + 1. - a;
	printf("circle %f %f %f %d %d\n", G.x, G.y, r, angl2, 64 * 180 - 2 * angl2);
	printf("circle %f %f %f %d %d\n", F.x, F.y, 1. - a, 64 * 180 - angl2, angl2 - angl1);
	printf("circle %f %f %f %d %d\n", E.x, E.y, 1. + a, angl1 + 64 * 180, angl2 - angl1);
	printf("circle %f %f %f %d %d\n", G.x, G.y, 2. - r, angl2 + 64 * 180, 64 * 180 - 2 * angl2);
	printf("circle %f %f %f %d %d\n", F.x, F.y, 1. + a, 64 * 360 - angl2, angl2 - angl1);
	return 0;
}
