#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define hp 0.5*M_PI

double h(double t)
{
	if(t > M_PI) return 2 - h(t - M_PI);
	return 4 * (t - hp) * (t - hp) / (M_PI * M_PI);
}

double h1(double t)
{
	if(t > M_PI) return -h1(t - M_PI);
	return 8 * (t - hp) / (M_PI * M_PI);
}

int main()
{
	double t, x, y, x0, y0;

	x0 = h(0.); y0 = h1(0.);
	for(t = 0; t < 2 * M_PI; t += 0.1) {
		printf("connect %f %f %f %f\n", x0, y0, x = cos(t) * h(t) - sin(t) * h1(t), y = sin(t) * h(t) + cos(t) * h1(t));
		x0 = x; y0 = y;
	}
	return 0;
}
