#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define hp 0.5*M_PI

double a = 1.;
double b = 1.4;

double h(double t)
{
	if(t > M_PI) return 2 - h(t - M_PI);
	if(t < M_PI / b) return 1. + a * cos(b * t);
	else return 1 - a;
}

double h1(double t)
{
	if(t > M_PI) return -h1(t - M_PI);
	if(t < M_PI / b) return -a * b * sin(b * t);
	else return 0.;
}

int main()
{
	double t, x, y, x0, y0;

	x0 = h(0.); y0 = h1(0.);
	for(t = 0; t < 2 * M_PI + .05; t += 0.05) {
		printf("connect %f %f %f %f\n", x0, y0, x = cos(t) * h(t) - sin(t) * h1(t), y = sin(t) * h(t) + cos(t) * h1(t));
		x0 = x; y0 = y;
	}
	return 0;
}
