#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[])
{
    int n = 2;
    double t, dt = .01, x, y, x0, y0 = 0., r, r2 = 1.5;

    if(argc > 1) n = atoi(argv[1]);
    if(argc > 2) r2 = atof(argv[2]);
    r = 1./(double) n;
	x0 = 1. + r * (1. - r2); 
    printf("gray 0.5\ncircle 0 0 1\ngray 0\n");
	for(t = dt; t < 2 * M_PI; t += dt){
		x = (1. + r) * cos(t) - r2 * r * cos((n + 1) * t);
		y = (1. + r) * sin(t) - r2 * r * sin((n + 1) * t);
		printf("connect %f %f %f %f\n", x0, y0, x, y);
		x0 = x; y0 = y;
	}
	return 0;
}
