#include <stdio.h>
#include <stdlib.h>
#include "planegeometry.h"

POINT A, B, C, D, E, F, P;

double abs(double x)
{
	if(x < 0.) return -x;
	else return x;
}

int isin(POINT A, POINT B, POINT P)
{
	LINE l;

	l = A * B;
	if(abs(l.a) > abs(l.b)) {
		if(A.y > B.y) {
			if((P.y > A.y) || (P.y < B.y)) return 0;
			else return 1;
		}
		else {
			if((P.y < A.y) || (P.y > B.y)) return 0;
			else return 1;
		}
	}
	else {
		if(A.x > B.x) {
			if((P.x > A.x) || (P.x < B.x)) return 0;
			else return 1;
		}
		else {
			if((P.x < A.x) || (P.x > B.x)) return 0;
			else return 1;
		}
	}
}

int main(int argc, char *argv[])
{
	int i, j;

	if(argc > 1) A.x = atof(argv[1]);
	if(argc > 2) A.y = atof(argv[2]);
	if(argc > 3) B.x = atof(argv[3]);
	if(argc > 4) B.y = atof(argv[4]);
	if(argc > 5) C.x = atof(argv[5]);
	if(argc > 6) C.y = atof(argv[6]);
	if(isin(A, B, C) > 0) printf("Interor\n");
	else printf("Not\n");
	return 0;
}
