#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "complexn2.h"

int main(int argc, char *argv[])
{
	CPX a, b, ca, g;
	double d;

	if(argc < 3) {
		fprintf(stderr, "2 paramaters needed\n");
		return 0;
	}
	a = atocpx(argv[1]);
	if(abs(a) >= 1.) {
		fprintf(stderr, "%f+i%f is not a Ppoint\n", a.r, a.i);
		return 0;
	}
	b = atocpx(argv[2]);
	if(abs(b) >= 1.) {
		fprintf(stderr, "%f+i%f is not a Ppoint\n", b.r, b.i);
		return 0;
	}
	ca.r = -a.r; ca.i = a.i;
	g = (b - a) / (ca * b + 1.);
	printf("g = %f+i%f\n", g.r, g.i);
	d = abs(g);
	printf("abs of g = %f\n", d);
	printf("D of %f+i%f and %f+i%f = %f\n", a.r, a.i, b.r, b.i, log((1 + d) / (1 - d)));
	return 0;
}
