#include <stdio.h>
#include <stdlib.h>
#include "planegeometry.h"

POINT A, B, C, D, E, F, G, P, M[3];

double abs0(double x)
{
	if(x < 0.) return -x;
	else return x;
}

int isin(POINT A, POINT B, POINT P)
{
	LINE l;

	l = A * B;
	if(abs0(l.a) > abs0(l.b)) {
		if(A.y > B.y) {
			if((P.y > A.y) || (P.y < B.y)) return 0;
			else return 1;
		}
		else {
			if((P.y < A.y) || (P.y > B.y)) return 0;
			else return 1;
		}
	}
	else {
		if(A.x > B.x) {
			if((P.x > A.x) || (P.x < B.x)) return 0;
			else return 1;
		}
		else {
			if((P.x < A.x) || (P.x > B.x)) return 0;
			else return 1;
		}
	}
}

int main(int argc, char *argv[])
{
	int i, j;

	A.x = -2.; A.y = 1.5; B.x = -2.3; B.y = -1.; C.x = 3.; C.y = -1.;
	D.x = 2.; D.y = 2.; P.x = 0.; P.y = -1.;
	if(argc > 1) A.x = atof(argv[1]);
	if(argc > 2) A.y = atof(argv[2]);
	if(argc > 3) B.x = atof(argv[3]);
	if(argc > 4) B.y = atof(argv[4]);
	if(argc > 5) C.x = atof(argv[5]);
	if(argc > 6) C.y = atof(argv[6]);
	if(argc > 7) D.x = atof(argv[7]);
	if(argc > 8) D.y = atof(argv[8]);
	if(argc > 9) P.x = atof(argv[9]);
	if(argc > 10) P.y = atof(argv[10]);
	printf("connect %f %f %f %f %f %f %f %f %f %f\n",  A.x, A.y, B.x, B.y, C.x, C.y, D.x, D.y, A.x, A.y);
	divide(B, C, 3, M);
	printf("color 0 0 3\n");
	//	WRITE(M[0]); WRITE(M[1]);
	WRITE(P);
	if(isin(B, P, M[0]) > 0) {
		E = (A * B) * (D / (A * C));
		WRITE(E);
		F = (A * B) * (M[0] / (P * E));
		if(isin(A, B, F) > 0) WRITE(P, F);
		else {
			G = (A * D) * (F / (A * P));
			WRITE(P, G);
		}
		if(isin(B, P, M[1]) > 0) {
			E = (A * B) * (D / (A * C));
			WRITE(E);
			F = (A * B) * (M[1] / (P * E));
			if(isin(A, B, F) > 0) WRITE(P, F);
			else {
				G = (A * D) * (F / (A * P));
				WRITE(P, G);
			}
		}
		else {
			E = (C * D) * (A / (B * D));
			F = (C * D) * (M[1] / (P * E));
			if(isin(C, D, F) > 0) WRITE(P, F);
			else {
				G = (A * D) * (F / (D * P));
				WRITE(P, G);
			}
		}
	}
	printf("color 3 0 0\npause\n");
	if(isin(C, P, M[1]) > 0) {
		E = (C * D) * (A / (B * D));
		F = (C * D) * (M[1] / (P * E));
		if(isin(C, D, F) > 0) WRITE(P, F);
		else {
			G = (A * D) * (F / (D * P));
			WRITE(P, G);
		}
		if(isin(C, P, M[0]) > 0) {
			F = (C * D) * (M[0] / (P * E));
			if(isin(C, D, F) > 0) WRITE(P, F);
			else {
				G = (A * D) * (F / (D * P));
				WRITE(P, G);
			}
		}			
	}
	return 0;
}
