#include <stdio.h>
#include <stdlib.h>
#include "planegeometry.h"
#define ND 13

POINT A, B, C, D, E, F, G, H, P, M[ND-1];
LINE ab, bc, ac, bd, cd, ad;

double abs0(double x)
{
	if(x < 0.) return -x;
	else return x;
}

int isin(POINT A, POINT B, POINT P)
{
	LINE l;

	l = A * B;
	if(abs0(l.a) > abs0(l.b)) {
		if(A.y > B.y) {
			if((P.y > A.y) || (P.y < B.y)) return 0;
			else return 1;
		}
		else {
			if((P.y < A.y) || (P.y > B.y)) return 0;
			else return 1;
		}
	}
	else {
		if(A.x > B.x) {
			if((P.x > A.x) || (P.x < B.x)) return 0;
			else return 1;
		}
		else {
			if((P.x < A.x) || (P.x > B.x)) return 0;
			else return 1;
		}
	}
}

int main(int argc, char *argv[])
{
	int i, j;

	A.x = -2.; A.y = 1.5; B.x = -2.3; B.y = -1.; C.x = 3.; C.y = -1.;
	D.x = 2.; D.y = 2.; P.x = 0.; P.y = -1.;
	if(argc > 1) A.x = atof(argv[1]);
	if(argc > 2) A.y = atof(argv[2]);
	if(argc > 3) B.x = atof(argv[3]);
	if(argc > 4) B.y = atof(argv[4]);
	if(argc > 5) C.x = atof(argv[5]);
	if(argc > 6) C.y = atof(argv[6]);
	if(argc > 7) D.x = atof(argv[7]);
	if(argc > 8) D.y = atof(argv[8]);
	if(argc > 9) P.x = atof(argv[9]);
	if(argc > 10) P.y = atof(argv[10]);
	WRITE(A, B);
	WRITE(B, C);
	WRITE(C, D);
	WRITE(D, A);
	divide(B, C, ND, M);
	printf("color 0 0 3\n");
	ab = A * B;
	ac = A * C;
	bc = B * C;
	cd = C * D;
	ad = A * D;
	bd = B * D;
	E = ab * (D / ac);
	//	WRITE(E, C);
	for(i = 0; i < ND-1; i++) {
		if(isin(B, P, M[i]) > 0) {
			F = ab * (M[i] / (P * E));
			if(isin(A, B, F) > 0) {
				WRITE(F, P);
			}
			else {
				G = ad * (F / (A * P));
				WRITE(G, P);
			}
		}
		else {
			F = (E * C) * (M[i] / (E * P));
			//			WRITE(F, P);
			G = cd * (F / bc);
			if(isin(C, D, G) > 0) {
				WRITE(P, G);
			}
			else {
				H = ad * (G / (P * D));
				WRITE(P, H);
			}
		}
	}
	printf("color 3 0 0\npause\n");
	E = cd * (A / bd);
	for(i = 0; i < ND-1; i++) {
		if(isin(C, P, M[i]) > 0) {
			F = cd * (M[i] / (P * E));
			if(isin(C, D, F) > 0) {
				WRITE(F, P);
			}
			else {
				G = ad * (F / (D * P));
				WRITE(G, P);
			}
		}
		else {
			F = (E * B) * (M[i] / (E * P));
			G = ab * (F / bc);
			if(isin(A, B, G) > 0) {
				WRITE(P, G);
			}
			else {
				H = ad * (G / (P * A));
				WRITE(P, H);
			}
		}
	}
	return 0;
}
