#include <stdio.h>
#include <stdlib.h>
#include "planegeometry.h"

POINT A, B, C, D, E, F, G, H, P, M[2];
LINE ab, bc, ac, bd, cd, ad;

double abs0(double x)
{
	if(x < 0.) return -x;
	else return x;
}

int isin(POINT A, POINT B, POINT P)
{
	LINE l;

	l = A * B;
	if(abs0(l.a) > abs0(l.b)) {
		if(A.y > B.y) {
			if((P.y > A.y) || (P.y < B.y)) return 0;
			else return 1;
		}
		else {
			if((P.y < A.y) || (P.y > B.y)) return 0;
			else return 1;
		}
	}
	else {
		if(A.x > B.x) {
			if((P.x > A.x) || (P.x < B.x)) return 0;
			else return 1;
		}
		else {
			if((P.x < A.x) || (P.x > B.x)) return 0;
			else return 1;
		}
	}
}

int main(int argc, char *argv[])
{
	int i, j;

	A.x = -2.; A.y = 1.5; B.x = -2.3; B.y = -1.; C.x = 3.; C.y = -1.;
	D.x = 2.5; D.y = 2.; P.x = 0.; P.y = -1.;
	if(argc > 1) A.x = atof(argv[1]);
	if(argc > 2) A.y = atof(argv[2]);
	if(argc > 3) B.x = atof(argv[3]);
	if(argc > 4) B.y = atof(argv[4]);
	if(argc > 5) C.x = atof(argv[5]);
	if(argc > 6) C.y = atof(argv[6]);
	if(argc > 7) D.x = atof(argv[7]);
	if(argc > 8) D.y = atof(argv[8]);
	if(argc > 9) P.x = atof(argv[9]);
	if(argc > 10) P.y = atof(argv[10]);
	WRITE(A, B);
	WRITE(B, C);
	WRITE(C, D);
	WRITE(D, A);
	divide(B, C, 3, M);
	printf("color 0 0 2\n");
	ab = A * B;
	ac = A * C;
	bc = B * C;
	cd = C * D;
	ad = A * D;
	bd = B * D;
	E = ab * (D / ac);
	WRITE(A, C);
	WRITE(E, D);
	WRITE(E, C);
	WRITE(E, A);
	WRITE(E, P);
	if(isin(B, P, M[0]) > 0) {
		F = ab * (M[0] / (P * E));
		WRITE(F, M[0]);
		if(isin(A, B, F) > 0) {
			printf("color 0 0 3\n");
			WRITE(F, P);
		}
		else {
			G = ad * (F / (A * P));
			WRITE(F, G);
			WRITE(A, P);
			printf("color 0 0 3\n");
			WRITE(G, P);
		}
	}
	else {
		F = (E * C) * (M[0] / (E * P));
		WRITE(F, P);
		G = cd * (F / bc);
		if(isin(C, D, G) > 0) {
			WRITE(P, G);
		}
		else {
			H = ad * (G / (P * D));
			WRITE(P, H);
		}
	}

	E = cd * (A / bd);
	printf("pause\ncolor 2 0 0\n");
	WRITE(B, D);
	WRITE(E, A);
	WRITE(E, B);
	WRITE(E, D);
	WRITE(E, P);
	if(isin(C, P, M[0]) > 0) {
		F = cd * (M[0] / (P * E));
		WRITE(F, M[0]);
		if(isin(C, D, F) > 0) {
			printf("color 3 0 0\n");
			WRITE(F, P);
		}
		else {
			G = ad * (F / (D * P));
			WRITE(F, G);
			WRITE(D, P);
			printf("color 3 0 0\n");
			WRITE(G, P);
		}
	}
	else {
		F = (E * B) * (M[0] / (E * P));
		//		WRITE(F, P);
		WRITE(F, M[0]);
		G = ab * (F / bc);
		WRITE(F, G);
		if(isin(A, B, G) > 0) {
			printf("color 3 0 0\n");
			WRITE(P, G);
		}
		else {
			H = ad * (G / (P * A));
			//	WRITE(P, G);
			printf("color 3 0 0\n");
			WRITE(P, H);
		}
	}
	return 0;
}
