#include <stdio.h>
#include <stdlib.h>

int a[12], mt[12][9], unit[9], x[9], t[9], l[] = {1, 0, 11, 6,  9, 8, 3, 10, 5, 4, 7, 2};
//{9, 4, 7, 10, 1, 8, 11, 2, 5, 0, 3, 6};
//{3, 2, 1, 0, 7, 6, 5, 4, 11, 10, 9, 8};

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	   s = 0;
	   for(j = 0; j < m; j++) s += a[i * m + j] * b[j * n + k];
	   c[i * n + k] = s;
	}
    }
}

int isequalmt(int a[], int b[], int n)
{
    int i, n2 = n * n;

    for(i = 0; i < n2; i++) if(a[i] != b[i]) break;
    if(i < n2) return -1;
    else return 1;
}

void display(int a[], int m, int n)
{
    int i, j;

    for(i = 0; i < m; i++) {
        for(j = 0; j < n; j++) printf("%d ", a[i * n + j]);
	printf("\n");
    }
}

main(int argc, char *argv[])
{
    int i, j;

    if(argc <= 12) {
        fprintf(stderr, "12 parameters needed\n");
	return -1;
    }
    for(i = 0; i < 12; i++) a[i] = atoi(argv[i + 1]);
    //    for(i = 0; i < 12; i++) printf("%d ", a[l[i]]);
    for(i = 0; i < 12; i++) {
        for(j = 0; j < 9; j++) mt[i][j] = 0;
	mt[i][1] = -1; mt[i][3] = mt[i][8] = 1;
	mt[i][4] = a[i]; mt[i][7] = a[l[i]];
    }
    for(j = 1; j < 9; j++) unit[j] = 0;
    unit[0] = unit[4] = unit[8] = 1;
    mtxmul(mt[0], mt[1], t, 3, 3, 3);
    for(i = 2; i < 12; i++) {
        mtxmul(t, mt[i], x, 3, 3, 3);
	for(j = 0; j < 12; j++) t[j] = x[j];
    }
    //    display(x, 3, 3);
    if(isequalmt(x, unit, 3) == 1) printf("OK\n");
    else printf("not OK\n");
    return 0;
}
