#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double ab(double x)
{
	if(x < 0.) return -x;
	else return x;
}

void draw(double a, double b, double c)
{
	double r;

	r = sqrt(b * b + c * c - a * a) / ab(a);
	if(r <= 0.) return;
	if(ab(a) > 0.0001) printf("circle %f %f, %f\n", -b / a, -c / a, r);
	else printf("line %f %f 0\n", b, c);
}

int main(int argc, char *argv[])
{
	double a[3], b[3], c[3], r[3];
	int i;

	if(argc < 7) return 0;
	a[0] = atof(argv[1]);
	b[0] = atof(argv[2]);
	c[0] = atof(argv[3]);
	a[1] = atof(argv[4]);
	b[1] = atof(argv[5]);
	c[1] = atof(argv[6]);
	a[2] = c[0] * b[1] - b[0] * c[1];
	b[2] = c[0] * a[1] - c[1] * a[0];
	c[2] = a[0] * b[1] - a[1] * b[0];
	printf("circle 0 0 1\ncolor 0 0 3\n");
	draw(a[0], b[0], c[0]);
	printf("color 0 3 0\n");
	draw(a[1], b[1], c[1]);
	printf("color 3 0 0\n");
	draw(a[2], b[2], c[2]);
	return 0;
}

	
