#include <stdio.h>
#include <stdlib.h>

#define MAXP 7
#define MAXD 4

int p = 2, d = 4;

int sum(int x, int y)
{
	int i, j, z, ex[MAXP], ey[MAXP], ez[MAXP];

	for(i = 0; i < d; i++) {
		ex[i] = x % p; x /= p;
		ey[i] = y % p; y /= p;
	}
	for(i = 0; i < d; i++) ez[i] = (ex[i] + ey[i]) % p;
	for(z = 0, i = d - 1; i >= 0; i--) {
		z *= p;
		z += ez[i];
	}
	return z;
}


int mul(int x, int y)
{
	int i, j, z, ex[MAXP], ey[MAXP], ez[2 * MAXP];

	for(i = 0; i < d; i++) {
		ex[i] = x % p; x /= p;
		ey[i] = y % p; y /= p;
	}
	for(i = 0; i < 2 * d; i++) ez[i] = 0;
	for(i = 0; i < d; i++) {
		for(j = 0; j < d; j++) ez[i + j] += ex[i] * ey[j];
	}
	for(i = 2 * d - 1; i >= d; i--) {
		ez[i - 4] += ez[i];
		ez[i - 3] += ez[i];
	}
	for(i = 0; i < d; i++) ez[i] %= p;
	for(z = 0, i = d - 1; i >= 0; i--) {
		z *= p;
		z += ez[i];
	}
	return z;
}

int main()
{
	int i, j, n;

	for(i = 1, n = p; i < d; i++) n *= p;
	for(i = 0; i < n; i++) {
		for(j = 0; j < n; j++) printf("%d ", sum(i, j));
		printf("\n");
	}
	for(i = 1; i < n; i++) {
		for(j = 1; j < n; j++) printf("%d ", mul(i, j));
		printf("\n");
	}
	return 0;
}
