#include <stdio.h>
#include <math.h>

int pt[10][3];
double fdpt[3][2];

void drawtr(double x[], double y[], double z[])
{
	printf("connect %f %f %f %f %f %f %f %f\n", x[0], x[1], y[0], y[1], z[0], z[1], x[0], x[1]);
}

void triangle(int k, int l, int m)
{
	int i, j, sum, h;
	double x[2], y[2], z[2];

	for(h = 0; h < 3; h++) {
		for(sum = i = 0; i < 3; i++) sum += pt[k][i];
		for(i = 0; i < 2; i++) {
			for(x[i] = j = 0; j < 3; j++) x[i] += pt[k][j] * fdpt[(j + h) % 3][i];
			x[i] /= (double)sum;
		}
		for(sum = i = 0; i < 3; i++) sum += pt[l][i];
		for(i = 0; i < 2; i++) {
			for(y[i] = j = 0; j < 3; j++) y[i] += pt[l][j] * fdpt[(j + h) % 3][i];
			y[i] /= (double)sum;
		}
		for(sum = i = 0; i < 3; i++) sum += pt[m][i];
		for(i = 0; i < 2; i++) {
			for(z[i] = j = 0; j < 3; j++) z[i] += pt[m][j] * fdpt[(j + h) % 3][i];
			z[i] /= (double)sum;
		}
		drawtr(x, y, z);
	}
}

int main()
{
	int i, j;

	fdpt[0][0] = 0.; fdpt[0][1] = 1.;
	fdpt[1][1] = fdpt[2][1] = -0.5;
	fdpt[2][0] = -1 * (fdpt[1][0] = 0.5 * sqrt(3.));
	drawtr(fdpt[0], fdpt[1], fdpt[2]);
	pt[0][0] = 0; pt[0][1] = 0; pt[0][2] = 1; 
	pt[1][0] = 1; pt[1][1] = 0; pt[1][2] = 0; 
	pt[2][0] = 2; pt[2][1] = -1; pt[2][2] = 1;
	pt[3][0] = 1; pt[3][1] = -1; pt[3][2] = 2;
	pt[4][0] = 4; pt[4][1] = -3; pt[4][2] = 4;
	pt[5][0] = 7; pt[5][1] = -4; pt[5][2] = 4;
	pt[6][0] = 7; pt[6][1] = -6; pt[6][2] = 9;
	pt[7][0] = 4; pt[7][1] = -4; pt[7][2] = 7;
	pt[8][0] = 9; pt[8][1] = -6; pt[8][2] = 7;
	triangle(0, 1, 2);
	triangle(0, 2, 3);
	triangle(2, 3, 4);
	triangle(2, 4, 5);
	triangle(3, 4, 6);
	triangle(3, 6, 7);
	triangle(4, 5, 8);
	return 1;
}
