#include <stdio.h>
#include <math.h>

#define NOFD 18
#define NOFG 14

typedef struct rat {
	long u,d;
} rational;

rational h1[16], h2[16], h3[16], g1[16], g2[16], g3[16];

long gcd(long a, long b)
{
    long c;

    if(b < 0) b = -b;
    if(a==0) return b;
    if(a < 0) a = -a;
    for(;;){
      if((c = (b%a))==0) return a;
	else {
	    b = a;
	    a = c;
	}
    }
}

void prtr(rational x)
{
	printf("%ld", x.u);
	if(x.d != 1 && x.u != 0) printf("/%ld",x.d);
	printf(" ");
}

rational wa(rational x, rational y)
{
	rational z;
	long d;

	d = gcd(x.d, y.d);
	z.d = x.d * y.d/d;
	z.u = x.u * y.d/d + y.u * x.d/d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational seki(rational x, rational y)
{
	rational z;
	long d;

	z.d = x.d * y.d;
	z.u = x.u * y.u;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}


void mtxmul(rational a[], rational b[], rational c[], int l, int m, int n)
{
    int i, j, k;
    rational s;
    
    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	    s.u = 0; s.d = 1;
	    for(j = 0; j < m; j++) s = wa(s, seki(a[i * m + j], b[j * n + k]));
	    c[i * n + k] = s;
	}
    }
}

rational ator(char *str)
{
    char *str2;
    rational z;

    str2 = str;
    for(;*str2 != '\0';str2++){
        if(*str2 == '/') {
	    *(str2++) = '\0';
	    break;
	}
    }
    z.u = atol(str);
    if(*str2 == '\0') z.d = 1;
    else z.d = atol(str2);
    return z;
}

void swap(rational x[], rational y[])
{
	long t;

	t = x[0].u; x[0].u = y[0].u; y[0].u = t;
	t = x[0].d; x[0].d = y[0].d; y[0].d = t;
}

rational sa(rational x, rational y)
{
	rational z;
	long d;

	d = gcd(x.d, y.d);
	z.d = x.d * y.d/d;
	z.u = x.u * y.d/d - y.u * x.d/d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational syou(rational x, rational y)
{
	rational z;
	long d;

	z.d = x.d * y.u;
	z.u = x.u * y.d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	if(z.d<0) {
		z.u *= -1; z.d *= -1;
	}
	return z;
}

int solve(rational x[], rational y[])
{
    int i, j, k;
    rational t;
    
    for(i = 0; i < 4; i++) {
        int i2, j2, f;
	for(i2 = i; i2 < 4; i2++) {
			for(j2 = i; j2 < 4; j2++) if(x[j2 * 5 + i2].u != 0) break;
			if(j2 < 4) break;
	}
	if(i2 == 4) return 0;
	if(j2 > i) {
	    for(k = i; k < 5; k++) swap(x + i * 5 + k, x + j2 * 5 + k);
	    /*
	      printf("%d 行と %d 行を交換\n", i + 1, j2 + 1);
	      display(x,m,n);
	    */
	}
	if(i2 > i) {
	    for(k = 0; k < 4; k++) swap(x + k * 5 + i, x + k * 5 + i2);
			/*
			printf("%d 列と %d 列を交換\n", i + 1, i2 + 1);
			display(x,m,n);
			*/
	}
	t.u = x[i * 5 + i].u; t.d = x[i * 5 + i].d;
	if(t.u != 1 || t.d != 1) {
	    for(j = i; j < 5; j++) x[i * 5 + j] = syou(x[i * 5 + j], t);
	    /*
	      printf("%d 行に ", i + 1);
	      prtr(t);
	      printf(" の逆数を掛ける\n");
	      display(x,m,n);
	    */
	}
	for(f = j = 0; j < 4; j++) {
	    if(j == i || x[j * 5 + i].u == 0) continue;
	    f = 1;
	    t.u = x[j * 5 + i].u; t.d = x[j * 5 + i].d;
	    for(k = i; k < 5; k++) x[j * 5 + k] = sa(x[j * 5 + k], seki(t, x[i * 5 + k]));
	    t.u *= -1;
	    /*
	      printf("%d 行の ", i + 1);
	      prtr(t);
	      printf(" 倍を %d 行に加える\n", j + 1);
	    */
	}
	//		if(f == 1) display(x,m,n);
    }
    //	display(x, m, n);
    for(i = 0; i < 4; i++) y[i] = x[i * 5 + 4];
    return 1;
}


main(int argc, char *argv[])
{
    int i, j, k, l, m, n, ff, f[100];
    rational x[4], y[4], a[NOFD][4], b[20], t;
    double v[4], sq[4];
    
    if(argc < 5) return 0;
    for(i = 0; i < 4; i++) x[i] = ator(argv[i + 1]);
    sq[0] = sqrt(6.); sq[1] = sqrt(3.); sq[2] = sqrt(2.); sq[3] = 1.;
    for(i = 0; i < 16; i++) {
        h1[i].u = h2[i].u = h3[i].u = g1[i].u = g2[i].u = g3[i].u = 0;
	h1[i].d = h2[i].d = h3[i].d = g1[i].d = g2[i].d = g3[i].d = 1;
    }
    g1[0].u = g1[5].u = g1[10].u = g1[15].u = 3;
    g1[1].u = g1[11].u = 4; g1[4].u = g1[14].u = 2;
    h1[0].u = h1[5].u = h1[10].u = h1[15].u = 3;
    h1[1].u = h1[11].u = -4; h1[4].u = h1[14].u = -2;
    g2[0].u = g2[5].u = g2[10].u = g2[15].u = 2;
    g2[2].u = g2[7].u = 3; g2[8].u = g2[13].u = 1;
    h2[0].u = h2[5].u = h2[10].u = h2[15].u = 2;
    h2[2].u = h2[7].u = -3; h2[8].u = h2[13].u = -1;
    g3[0].u = g3[5].u = g3[10].u = g3[15].u = 5;
    g3[3].u = 12; g3[6].u = 6; g3[9].u = 4; g3[12].u = 2; 
    h3[0].u = h3[5].u = h3[10].u = h3[15].u = 5;
    h3[3].u = -12; h3[6].u = -6; h3[9].u = -4; h3[12].u = -2; 
    /*
    for(i = 0; i < 4; i++) prtr(x[i]);
    printf("\n");
    */
    mtxmul(g1, x, a[0], 4, 4, 1);
    mtxmul(h1, x, a[1], 4, 4, 1);
    mtxmul(g2, x, a[2], 4, 4, 1);
    mtxmul(h2, x, a[3], 4, 4, 1);
    mtxmul(g3, x, a[4], 4, 4, 1);
    mtxmul(h3, x, a[5], 4, 4, 1);
    mtxmul(g2, a[0], a[6], 4, 4, 1);
    mtxmul(h2, a[1], a[7], 4, 4, 1);
    mtxmul(h2, a[0], a[8], 4, 4, 1);
    mtxmul(g2, a[1], a[9], 4, 4, 1);
    mtxmul(g3, a[2], a[10], 4, 4, 1);
    mtxmul(h3, a[3], a[11], 4, 4, 1);
    mtxmul(h3, a[2], a[12], 4, 4, 1);
    mtxmul(g3, a[3], a[13], 4, 4, 1);
    mtxmul(g3, a[0], a[14], 4, 4, 1);
    mtxmul(h3, a[1], a[15], 4, 4, 1);
    mtxmul(h3, a[0], a[16], 4, 4, 1);
    mtxmul(g3, a[1], a[17], 4, 4, 1);
    /*
    for(i = 0; i < 12; i++) {
        for(j = 0; j < 4; j++) prtr(a[i][j]);
	printf("\n");
    }
    */
    n = 0; 
    for(i = 0; i < NOFG - 2; i++) {
        for(j = i + 1; j < NOFG - 1; j++) {
	    for(k = j + 1; k < NOFG; k++) {
	        for(l = 0; l < 4; l++) b[l] = x[l];
		for(l = 4; l < 20; l += 5) b[l].u = b[l].d = 1;
		for(l = 0; l < 4; l++) b[5 + l] = a[i][l];
		for(l = 0; l < 4; l++) b[10 + l] = a[j][l];
		for(l = 0; l < 4; l++) b[15 + l] = a[k][l];
		if(solve(b, y) == 0) continue;
		for(ff = l = 0; l < NOFG; l++) {
		    t.u = 0; t.d = 1;
		    for(m = 0; m < 4; m++) t = wa(t, seki(y[m], a[l][m]));
		    if(t.u < t.d) break;
		    if(t.u == t.d) ff++;
		    ff *= 2;
		}
		if(l < NOFG) continue;
		for(l = 0; l < n; l++) if(f[l] == ff) break;
		if(l < n) continue;
		f[n++] = ff;
		for(l = 0; l < 4; l++) prtr(y[l]);
		printf(" \t");
		for(l = NOFG - 1; l >= 0; l--) {
		    ff /= 2;
		    if((ff % 2) == 1) printf(" %d", l);
		}
		for(l = 0; l < 4; l++) v[l] = sq[l] * y[l].u / (double) y[l].d;
		printf("\t\t%f, %f, %f, %f\n", v[0] + v[1] + v[2] + v[3], v[0] + v[1] - v[2] - v[3], v[0] - v[1] + v[2] - v[3], v[0] - v[1] - v[2] + v[3]);
	    }
	}
    }
    return 0;
}
