#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "complexn2.h"

GI remainder(GI a, GI b)
{

	GI c;
	CPX x, y, z;

	x.r = a.r; x.i = a.i;
	y.r = b.r; y.i = b.i;
	z = x / y;
	c.r = z.r; c.i = z.i;
	if((z.r - c.r) > 0.5) c.r++;
	if((z.i - c.i) > 0.5) c.i++;
	return a - b * c;
}

long norm(GI a)
{
	return a.r * a.r + a.i * a.i;
}

int main(int argc, char *argv[])
{
	GI a, d;
	long nr, sqn;

	if(argc < 2) return 0;
	a = atogi(argv[1]);
	if((nr = norm(a)) < 2) return 0;
	if(nr == 2) {
		wtgi(a); printf(" is prime number\n");
		return 0;
	}
	sqn = sqrt(nr);
	for(d.r = d.i = 1; ;) {
		if((nr % norm(d)) == 0) {
			if(norm(remainder(a, d)) == 0) {
				printf("("); wtgi(d); printf(")");
				a = a / d;
				nr = norm(a);
				sqn = sqrt(nr);
				continue;
			}
			d.i *= -1;
			if(norm(remainder(a, d)) == 0) {
				printf("("); wtgi(d); printf(")");
				a = a / d;
				nr = norm(a);
				sqn = sqrt(nr);
				continue;
			}
			d.i *= -1;
		}
		if(d.i == d.r) {
			d.r++;
			if(d.r * d.r > sqn) break;
			d.i = 0;
		}
		else d.i++;
	}
	printf("("); wtgi(a); printf(")\n");
	return 0;
}
