#include <stdio.h>
#include <stdlib.h>

#define MAXN 2000
#define DM 4
#define maxd 6

int m, n, mt[MAXN][DM * DM];

void mtxmul(int a[], int b[], int c[])
{
    int i, j, k, s;

    for(i = 0; i < DM; i++) {
        for(k = 0; k < DM; k++) {
			s = 0;
			for(j = 0; j < DM; j++) s += a[i * DM + j] * b[j * DM + k];
			c[i * DM + k] = s;
		}
    }
}

void display(int a[])
{
    int i, j;

    for(i = 0; i < DM; i++) {
        for(j = 0; j < DM; j++) fprintf(stderr, "%d ", a[i * DM + j]);
		fprintf(stderr, "\n");
    }
}

int alex()
{
	int i, j;

	for(i = 0; i < n; i++) {
		for(j = 0; j < DM * DM; j++) if(mt[i][j] != mt[n][j]) break;
		if(j == DM * DM) return i;
	}
	return -1;
}

int det(int n, int a[])
{
    int i, j, b[maxd*maxd], d, d2;

    if(n < 1) return 0;
    if(n == 1) return a[0];
    if(n == 2) return a[0] * a[3] - a[1] * a[2];

    for(i = 0; i < n - 1; i++) {
		for(j = 0; j < n - 1; j++) b[i * (n - 1) + j] = a[(i + 1) * n + j + 1];
    }
    d = a[0] * det(n - 1, b);
    for(i = 1; i < n; i++){
		for(j = 0; j < n - 1; j++) b[(i - 1) * (n - 1) + j] = a[(i - 1) * n + j + 1];
		d2 = a[i * n] * det(n - 1, b);
		if((i % 2) == 1) d2 *= -1;
		d += d2;
    }
    return d;
}

int main(int argc, char *argv[])
{
    int i, j, k, l, a[DM * DM];

	if(argc > 1) l = atoi(argv[1]);
	else l = 1;
	for(i = 0; i < DM * DM; i++) mt[0][i] = 0;
	for(i = 0; i < DM; i++) mt[0][i * DM + i] = 1;
	for(i = 1; i <= l; i++) {
		for(j = 0; j < DM * DM; j++) scanf("%d", mt[i] + j);
	}
	m = 1;
	n = l + 1;
	for(i = 0; i < n; i++) {
		for(j = 0; j < DM * DM; j++) a[j] = mt[i][j];
		for(j = 0; j < DM; j++) a[j * DM + j]--;
		if(det(DM, a) != 0) display(mt[i]);
	}
	for( ; ; ) {
		for(i = 1; i <= m; i++) {
			mtxmul(mt[i], mt[m], mt[n]);
			if(alex() == -1){
				for(j = 0; j < DM * DM; j++) a[j] = mt[n][j];
				for(j = 0; j < DM; j++) a[j * DM + j]--;
				if(det(DM, a) != 0) display(mt[n]);
				n++;
				if(n == MAXN) return -1;
			}
			mtxmul(mt[m], mt[i], mt[n]);
			if(alex() == -1){
				for(j = 0; j < DM * DM; j++) a[j] = mt[n][j];
				for(j = 0; j < DM; j++) a[j * DM + j]--;
				if(det(DM, a) != 0) display(mt[n]);
				n++;
				if(n == MAXN) return -1;
			}
		}
		m++;
		if(m == n) break;
	}
	for(i = 0; i < n; i++) {
		for(j = 0; j < n; j++) {
			mtxmul(mt[i], mt[j], mt[n]);
			printf("%d ", alex());
		}
		printf("\n");
	}
	return 0;
}
