#include <stdio.h>
#include <stdlib.h>

#define maxd 20

typedef struct rat {
	long u,d;
} rational;

rational x[maxd*maxd], y[maxd*maxd];

long gcd(long a, long b);
int wordcut(char *str, char *a[]);
int getl(char *s);
int lengthofrat(rational x);
void prtr(rational x);
void swap(rational x[], rational y[]);
rational sa(rational x, rational y);
rational seki(rational x, rational y);
rational syou(rational x, rational y);
rational ator(char *s);
void display(rational *x, rational *y, int n);

int main(argc,argv)
	int argc;
	char *argv[];
{
	int i, j, k, n;
	char str[256], *a[maxd];
/*	void display(), prtr(), swap();
	rational t, ator(), sa(), seki(), syou(); */
	rational t;

	if(argc<2) n = 4;
	else if((n = atoi(argv[1]))>maxd) exit(0);
	for(i = 0; i<n; i++) {
		getl(str);
		if(wordcut(str,a)<n) exit(0);
		for(j = 0; j<n; j++) x[i*n + j] = ator(a[j]);
	}
	for(i = 0; i<n*n; i++) {
		y[i].u = 0;
		y[i].d = 1;
	}
	for(i = 0; i<n; i++) y[i*n+i].u = y[i*n+i].d = 1;
	display(x,y,n);
	for(i = 0; i<n; i++) {
		int j2, f;
		for(j2 = i; j2 < n; j2++) if(x[j2*n + i].u != 0) break;
		if(j2 == n) break;
		if(j2>i) {
			for(k = i; k<n; k++) swap(x + i*n + k, x + j2*n + k);
			for(k = 0; k<n; k++) swap(y + i*n + k, y + j2*n + k);
			printf("%d 行と %d 行を交換\n", i + 1, j2 + 1);
			display(x,y,n);
		}
		t.u = x[i*n + i].u; t.d = x[i*n + i].d;
		if(t.u != 1 || t.d != 1) {
			for(j = i; j < n; j++) x[i*n + j] = syou(x[i*n + j], t);
			for(j = 0; j < n; j++) y[i*n + j] = syou(y[i*n + j], t);
			printf("%d 行に ", i + 1);
			prtr(t);
			printf(" の逆数を掛ける\n");
			display(x,y,n);
		}
		for(f = j = 0; j < n; j++) {
			if(j == i || x[j*n + i].u == 0) continue;
			f = 1;
			t.u = x[j*n + i].u; t.d = x[j*n + i].d;
			for(k = i; k < n; k++) x[j*n + k] = sa(x[j*n + k], seki(t, x[i*n + k]));
			for(k = 0; k < n; k++) y[j*n + k] = sa(y[j*n + k], seki(t, y[i*n + k]));
			t.u *= -1;
			printf("%d 行の ", i + 1);
			prtr(t);
			printf(" 倍を %d 行に加える\n", j + 1);
		}
		if(f == 1) display(x,y,n);
	}
	if(i < n) printf("逆行列は存在しません。\n");
	return 1;
}

void swap(x,y)
	rational x[], y[];
{
	long t;

	t = x[0].u; x[0].u = y[0].u; y[0].u = t;
	t = x[0].d; x[0].d = y[0].d; y[0].d = t;
}

#define maxl 13

void display(x,y,n)
	rational x[], y[];
	int n;
{
	int i, j, k, l;

	for(i = 0; i< n; i++) {
		for(j = 0; j<n ;j++) {
			l = lengthofrat(x[i*n + j]);
			for(k = 0; k<(maxl - l)/2; k++) printf(" ");
			prtr(x[i*n + j]);
			for(k = 0; k<(maxl - l) - (maxl - l)/2; k++) printf(" ");
		}
		printf("|");
		for(j = 0; j<n ;j++) {
			l = lengthofrat(y[i*n + j]);
			for(k = 0; k<(maxl - l)/2; k++) printf(" ");
			prtr(y[i*n + j]);
			for(k = 0; k<(maxl - l) - (maxl - l)/2; k++) printf(" ");
		}
		printf("\n");
	}
	printf("\n");
}

int lengthofrat(x)
	rational x;
{
	int l = 0, y;

	if(x.u<0) {
		l++;
		y = -x.u;
	}
	else y = x.u;
	for(l++; y>=10; l++) y /= 10;
	if(x.d != 1 && x.u != 0) {
		l += 2;
		for(y = x.d; y>=10; l++) y /= 10;
	}
	return l;
}

void prtr(x)
	rational x;
{
	printf("%ld", x.u);
	if(x.d != 1 && x.u != 0) printf("/%ld",x.d);
}

rational ator(str)
	char *str;
{
	char *str2;
	rational z;

	str2 = str;
	for(;*str2 != '\0';str2++){
		if(*str2 == '/') {
			*(str2++) = '\0';
			break;
		}
	}
	z.u = atol(str);
	if(*str2 == '\0') z.d = 1;
	else z.d = atol(str2);
	return z;
}

#define buffer2 255

int getl(s)
    register char *s;
{
    static int f=0;
    register int n,l=0;
    if(f==1) return(-1);
    for(;l<buffer2;s++,l++) {
	    if((n=read(0,s,1))>0) {
    	    if(*s=='\n') {
        		*s='\0';
        		return(l);
      		}
    	}
    	else {
       		if(l==0) return(-1);
      		f=1;
      		*s='\0';
      		return(l);
    	}
  	}
  	return(buffer2);
}

int wordcut(str, a)
	char *str;
	char *a[];
{
	int n = 1;

	if(*str == '\0') return 0;
	a[0] = str;
	for(;*str != '\0';str++) {
		if(*str == ' ' || *str == ',' || *str == '\t') {
			a[n++] = str + 1;
			*str = '\0';
		}
	}
	if(*a[n-1] == '\0') n--;
	return n;
}

rational sa(x,y)
	rational x, y;
{
	rational z;
	long d;

	d = gcd(x.d, y.d);
	z.d = x.d * y.d/d;
	z.u = x.u * y.d/d - y.u * x.d/d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational seki(x,y)
	rational x,y;
{
	rational z;
	long d;

	z.d = x.d * y.d;
	z.u = x.u * y.u;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational syou(x,y)
	rational x,y;
{
	rational z;
	long d;

	z.d = x.d * y.u;
	z.u = x.u * y.d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	if(z.d<0) {
		z.u *= -1; z.d *= -1;
	}
	return z;
}

long gcd(a,b)
	long a,b;
{
	long c;
	if(b<0)
		b = -b;
	if(a==0)
		return(b);
	if(a<0)
		a = -a;
	for(;;){
		if((c=b%a)==0)
			return a;
		else {
			b=a;
			a=c;
		}
	}
}
