#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[])
{
	double t, x, y, x0, y0, b, dt = .02, nr, ct, st;

	if(argc > 1) b = atof(argv[1]);
	else b = 0.8; 
	x0 = 1.; y0 = 0.;
	for(t = dt; t < M_PI; t += dt) {
		x = cos(t); y = b * sin(t);
		printf("connect %f %f %f %f\n", x0, y0, x, y);
		x0 = x; y0 = y;
	}
	for(t = 0.; t < M_PI; t += dt) {
		ct = cos(t); st = sin(t);
		nr = sqrt(st * st + b * b * ct * ct);
		x = ct - 2. * b * ct / nr;
		y = b * st - 2. * st / nr;
		printf("connect %f %f %f %f\n", x0, y0, x, y);
		x0 = x; y0 = y;
	}
	printf("connect %f %f 1. 0.\n", x0, y0);
	return 0;
}
