#include <stdio.h>
#include <stdlib.h>

#define MAXP 10

int u[MAXP * MAXP * MAXP];

int isprime(int p)
{
	int i;

	for(i = 2; i + i <= p; i++) if((p % i) == 0) return -1;
	return 1;
}

int main(int argc, char *argv[])
{
	int i, j, x, p, p2;
	if(argc < 2) {
		printf("One parameter needed.\n");
		return 0;
	}
	p = atoi(argv[1]);
	if(p > MAXP || p < 2) return 0;
	if(isprime(p) < 1) {
		fprintf(stderr, "引数は素数でなければダメ\n");
		return 0;
	}
	p2 = p * p;
	for(i = 0; i < p2 * p; i++) u[i] = 0;
	for(i = 0; i < p2; i++) {
		int c1 = i / p, c0 = i % p; 
		for(j = 0; j < p; j++) {
				u[((c1 + j) % p) * p2 + ((c1 * j + c0) % p) * p + (c0 * j) % p] = 1;
		}
	}
		for(i = 0; i < p2 * p; i++) if(u[i] == 0) printf("x^3+%dx^2+%dx+%d\n", i / p2, (i / p) % p, i % p);
	return 0;
}
