#include <stdio.h>
#include <stdlib.h>
#define MAXP 100

int u[MAXP * MAXP];

int isprime(int p)
{
	int i;

	for(i = 2; i + i <= p; i++) if((p % i) == 0) return -1;
	return 1;
}

int main(int argc, char *argv[])
{
	int i, j, x, p;
	if(argc < 2) {
		printf("One parameter needed.\n");
		return 0;
	}
	p = atoi(argv[1]);
	if(p > MAXP || p < 2) return 0;
	if(isprime(p) < 1) {
		fprintf(stderr, "引数は素数でなければダメ\n");
		return 0;
	}
	for(i = 0; i < p * p; i++) u[i] = 0;
	for(i = 0; i < p; i++) {
		for(j = 0; j <= i; j++) u[((i + j) % p) * p + (i * j) % p] = 1;
	}
	for(i = 0; i < p * p; i++) if(u[i] == 0) printf("x^2+%dx+%d\n", i / p, i % p);
	return 0;
}
