#include <stdio.h>
#include <stdlib.h>
#include "spacegeometry.h"

POINT isof3pl(Plane u, Plane v, Plane w)
{
	POINT p;
	double d;

	d = u.a * v.b * w.c + u.b * v.c * w.a + u.c * v.a * w.b - u.a * v.c * w.b - u.c * v.b * w.a - u.b * v.a * w.c;
	p.x = (u.d * v.b * w.c + u.b * v.c * w.d + u.c * v.d * w.b - u.d * v.c * w.b - u.c * v.b * w.d - u.b * v.d * w.c) / d;
	p.y = (u.a * v.d * w.c + u.d * v.c * w.a + u.c * v.a * w.d - u.a * v.c * w.d - u.c * v.d * w.a - u.d * v.a * w.c) / d;
	p.z = (u.a * v.b * w.d + u.b * v.d * w.a + u.d * v.a * w.b - u.a * v.d * w.b - u.d * v.b * w.a - u.b * v.a * w.d) / d;
	return p;
}

int main(int argc, char *argv[])
{
	POINT p;
	Plane u, v, w;

	if(argc < 13) return 0;
	u.a = atof(argv[1]);
	u.b = atof(argv[2]);
	u.c = atof(argv[3]);
	u.d = atof(argv[4]);
	v.a = atof(argv[5]);
	v.b = atof(argv[6]);
	v.c = atof(argv[7]);
	v.d = atof(argv[8]);
	w.a = atof(argv[9]);
	w.b = atof(argv[10]);
	w.c = atof(argv[11]);
	w.d = atof(argv[12]);
	p = isof3pl(u, v, w);
	printf("(%f, %f, %f)\n", p.x, p.y, p.z);
	return 0;
}
