#include <stdio.h>

#define maxd 10

typedef struct rat {
	long u,d;
} rational;

rational x[maxd*maxd], y[maxd], z[maxd];
char var[] = {'u', 'v', 'w', 'x', 'y', 'z'};

long gcd(long a, long b);
int wordcut(char *str, char *a[]);
int getl(char *s);
int lengthofrat(rational x);
void prtr(rational x);
void swap(rational x[], rational y[]);
rational sa(rational x, rational y);
rational wa(rational x, rational y);
rational seki(rational x, rational y);
rational syou(rational x, rational y);
rational ator(char *s);
//void display(rational *x, int m, int n);

main(int argc, char *argv[])
{
	int i, j, k, m, n;
	rational t;
	char str[256], *a[maxd];

	if(argc<3) {
		m = 3;
		n = 4;
	}
	else {
		if((m = atoi(argv[1]))>maxd-1) return 0;
		if((n = atoi(argv[2]))>maxd) return 0;
	}
	for(i = 0; i<m; i++) {
		getl(str);
		if(wordcut(str,a)<n) return 0;
		for(j = 0; j<n; j++) x[i*n + j] = ator(a[j]);
	}
	//	display(x,m,n);
	for(i = 0; i<m; i++) {
		int i2, j2, f;
		for(i2 = i; i2 < m; i2++) {
			for(j2 = i; j2 < m; j2++) if(x[j2*n + i2].u != 0) break;
			if(j2 < m) break;
		}
		if(i2 == m) break;
		if(j2>i) {
			for(k = i; k<n; k++) swap(x + i*n + k, x + j2*n + k);
			/*
			printf("%d 行と %d 行を交換\n", i + 1, j2 + 1);
			display(x,m,n);
			*/
		}
		if(i2>i) {
			char s;
			for(k = 0; k<m; k++) swap(x + k*n + i, x + k*n + i2);
			s = var[i]; var[i] = var[i2]; var[i2] = s;
			/*
			printf("%d 列と %d 列を交換\n", i + 1, i2 + 1);
			display(x,m,n);
			*/
		}
		t.u = x[i*n + i].u; t.d = x[i*n + i].d;
		if(t.u != 1 || t.d != 1) {
			for(j = i; j < n; j++) x[i*n + j] = syou(x[i*n + j], t);
			/*
			printf("%d 行に ", i + 1);
			prtr(t);
			printf(" の逆数を掛ける\n");
			display(x,m,n);
			*/
		}
		for(f = j = 0; j < m; j++) {
			if(j == i || x[j*n + i].u == 0) continue;
			f = 1;
			t.u = x[j*n + i].u; t.d = x[j*n + i].d;
			for(k = i; k < n; k++) x[j*n + k] = sa(x[j*n + k], seki(t, x[i*n + k]));
			t.u *= -1;
			/*
			printf("%d 行の ", i + 1);
			prtr(t);
			printf(" 倍を %d 行に加える\n", j + 1);
			*/
		}
		//		if(f == 1) display(x,m,n);
	}
	//	display(x, m, n);
	for(i = 0; i < m; i++) prtr(y[i] = x[i * n + n - 1]);
	printf("\n");
	for(;;) {
	        getl(str);
		if(wordcut(str,a)<n) return 0;
		for(j = 0; j<n; j++) prtr(z[j] = ator(a[j]));
		printf("   \t");
		t = seki(y[0], z[0]);
		for(j = 1; j < m; j++) t = wa(t, seki(y[j], z[j]));
		prtr(t);
		printf("\n");
	}
	return 0;
}

void swap(rational x[], rational y[])
{
	long t;

	t = x[0].u; x[0].u = y[0].u; y[0].u = t;
	t = x[0].d; x[0].d = y[0].d; y[0].d = t;
}

#define maxl 15

void display(rational x[], int m, int n)
{
	int i, j, k, l;

	printf(" ");
	for(j = 0; j<m ;j++) {
		for(k = 0; k<(maxl - 1)/2; k++) printf(" ");
		printf("%c", var[j]);
		for(k = 0; k<(maxl - 1) - (maxl - 1)/2; k++) printf(" ");
	}
	printf("\n");
	for(i = 0; i< m; i++) {
		printf("|");
		for(j = 0; j<n ;j++) {
			l = lengthofrat(x[i*n + j]);
			for(k = 0; k<(maxl - l)/2; k++) printf(" ");
			prtr(x[i*n + j]);
			for(k = 0; k<(maxl - l) - (maxl - l)/2; k++) printf(" ");
		}
		printf("|\n");
	}
	printf("\n");
}

int lengthofrat(rational x)
{
	int l = 0, y;

	if(x.u<0) {
		l++;
		y = -x.u;
	}
	else y = x.u;
	for(l++; y>=10; l++) y /= 10;
	if(x.d != 1 && x.u != 0) {
		l += 2;
		for(y = x.d; y>=10; l++) y /= 10;
	}
	return l;
}

void prtr(rational x)
{
	printf("%ld", x.u);
	if(x.d != 1 && x.u != 0) printf("/%ld",x.d);
	printf(" ");
}

rational ator(char *str)
{
	char *str2;
	rational z;

	str2 = str;
	for(;*str2 != '\0';str2++){
		if(*str2 == '/') {
			*(str2++) = '\0';
			break;
		}
	}
	z.u = atol(str);
	if(*str2 == '\0') z.d = 1;
	else z.d = atol(str2);
	return z;
}

#define buffer2 255

int getl(register char *s)
{
    static int f=0;
    register int n,l=0;
    if(f==1) return -1;
    for(;l<buffer2;s++,l++) {
	    if((n=read(0,s,1))>0) {
    	    if(*s=='\n') {
        		*s='\0';
        		return l;
      		}
    	}
    	else {
       		if(l==0) return -1;
      		f=1;
      		*s='\0';
      		return l;
    	}
  	}
  	return buffer2;
}

int wordcut(char *str, char *a[])
{
	int n = 1;

	if(*str == '\0') return 0;
	a[0] = str;
	for(;*str != '\0';str++) {
		if(*str == ' ' || *str == ',' || *str == '\t') {
			a[n++] = str + 1;
			*str = '\0';
		}
	}
	if(*a[n-1] == '\0') n--;
	return n;
}

rational sa(rational x, rational y)
{
	rational z;
	long d;

	d = gcd(x.d, y.d);
	z.d = x.d * y.d/d;
	z.u = x.u * y.d/d - y.u * x.d/d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational wa(rational x, rational y)
{
	rational z;
	long d;

	d = gcd(x.d, y.d);
	z.d = x.d * y.d/d;
	z.u = x.u * y.d/d + y.u * x.d/d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational seki(rational x, rational y)
{
	rational z;
	long d;

	z.d = x.d * y.d;
	z.u = x.u * y.u;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational syou(rational x, rational y)
{
	rational z;
	long d;

	z.d = x.d * y.u;
	z.u = x.u * y.d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	if(z.d<0) {
		z.u *= -1; z.d *= -1;
	}
	return z;
}

long gcd(long a, long b)
{
	long c;
	if(b<0)
		b = -b;
	if(a==0)
		return b;
	if(a<0)
		a = -a;
	for(;;){
		if((c=b%a)==0)
			return a;
		else {
			b=a;
			a=c;
		}
	}
}
