#include <stdio.h>

#define dim 4

typedef struct rat {
	long u,d;
} rational;

long gcd(long a, long b)
{
	long c;
	if(b<0)
		b = -b;
	if(a==0)
		return b;
	if(a<0)
		a = -a;
	for(;;){
		if((c=b%a)==0)
			return a;
		else {
			b=a;
			a=c;
		}
	}
}

int wordcut(char *str, char *a[])
{
	int n = 1;

	if(*str == '\0') return 0;
	a[0] = str;
	for(;*str != '\0';str++) {
		if(*str == ' ' || *str == ',' || *str == '\t') {
			a[n++] = str + 1;
			*str = '\0';
		}
	}
	if(*a[n-1] == '\0') n--;
	return n;
}

#define buffer2 255

int getl(register char *s)
{
    static int f=0;
    register int n,l=0;
    if(f==1) return -1;
    for(;l<buffer2;s++,l++) {
	    if((n=read(0,s,1))>0) {
    	    if(*s=='\n') {
        		*s='\0';
        		return l;
      		}
    	}
    	else {
       		if(l==0) return -1;
      		f=1;
      		*s='\0';
      		return l;
    	}
  	}
  	return buffer2;
}

int lengthofrat(rational x)
{
	int l = 0, y;

	if(x.u<0) {
		l++;
		y = -x.u;
	}
	else y = x.u;
	for(l++; y>=10; l++) y /= 10;
	if(x.d != 1 && x.u != 0) {
		l += 2;
		for(y = x.d; y>=10; l++) y /= 10;
	}
	return l;
}

void prtr(rational x)
{
	printf("%ld", x.u);
	if(x.d != 1 && x.u != 0) printf("/%ld",x.d);
	printf(" ");
}

rational ator(char *str)
{
	char *str2;
	rational z;

	str2 = str;
	for(;*str2 != '\0';str2++){
		if(*str2 == '/') {
			*(str2++) = '\0';
			break;
		}
	}
	z.u = atol(str);
	if(*str2 == '\0') z.d = 1;
	else z.d = atol(str2);
	return z;
}

void swap(rational x[], rational y[])
{
	long t;

	t = x[0].u; x[0].u = y[0].u; y[0].u = t;
	t = x[0].d; x[0].d = y[0].d; y[0].d = t;
}

rational sa(rational x, rational y)
{
	rational z;
	long d;

	d = gcd(x.d, y.d);
	z.d = x.d * y.d/d;
	z.u = x.u * y.d/d - y.u * x.d/d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational wa(rational x, rational y)
{
	rational z;
	long d;

	d = gcd(x.d, y.d);
	z.d = x.d * y.d/d;
	z.u = x.u * y.d/d + y.u * x.d/d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational seki(rational x, rational y)
{
	rational z;
	long d;

	z.d = x.d * y.d;
	z.u = x.u * y.u;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	return z;
}

rational syou(rational x, rational y)
{
	rational z;
	long d;

	z.d = x.d * y.u;
	z.u = x.u * y.d;
	d = gcd(z.u, z.d);
	if(d != 1) {
		z.u /= d;
		z.d /= d;
	}
	if(z.d<0) {
		z.u *= -1; z.d *= -1;
	}
	return z;
}

void solve(rational x[], rational y[])
{
    int i, j, k;
    rational t;
    
    for(i = 0; i < 4; i++) {
        int i2, j2, f;
	for(i2 = i; i2 < 4; i2++) {
			for(j2 = i; j2 < 4; j2++) if(x[j2 * 5 + i2].u != 0) break;
			if(j2 < 4) break;
	}
	if(i2 == 4) break;
	if(j2 > i) {
	    for(k = i; k < 5; k++) swap(x + i * 5 + k, x + j2 * 5 + k);
	    /*
	      printf("%d 行と %d 行を交換\n", i + 1, j2 + 1);
	      display(x,m,n);
	    */
	}
	if(i2 > i) {
	    for(k = 0; k < 4; k++) swap(x + k * 5 + i, x + k * 5 + i2);
			/*
			printf("%d 列と %d 列を交換\n", i + 1, i2 + 1);
			display(x,m,n);
			*/
	}
	t.u = x[i * 5 + i].u; t.d = x[i * 5 + i].d;
	if(t.u != 1 || t.d != 1) {
	    for(j = i; j < 5; j++) x[i * 5 + j] = syou(x[i * 5 + j], t);
	    /*
	      printf("%d 行に ", i + 1);
	      prtr(t);
	      printf(" の逆数を掛ける\n");
	      display(x,m,n);
	    */
	}
	for(f = j = 0; j < 4; j++) {
	    if(j == i || x[j * 5 + i].u == 0) continue;
	    f = 1;
	    t.u = x[j * 5 + i].u; t.d = x[j * 5 + i].d;
	    for(k = i; k < 5; k++) x[j * 5 + k] = sa(x[j * 5 + k], seki(t, x[i * 5 + k]));
	    t.u *= -1;
	    /*
	      printf("%d 行の ", i + 1);
	      prtr(t);
	      printf(" 倍を %d 行に加える\n", j + 1);
	    */
	}
	//		if(f == 1) display(x,m,n);
    }
    //	display(x, m, n);
    for(i = 0; i < 4; i++) y[i] = x[i * 5 + 4];
}

main()
{
    int i, j, k;
    rational x[20], y[4];
    char str[256], *a[5];

    for(i = 0; i < 4; i++) {
        getl(str);
	if(wordcut(str,a) < 5) return 0;
	for(j = 0; j < 5; j++) x[i * 5 + j] = ator(a[j]);
    }
    solve(x, y);
    for(i = 0; i < 4; i++) prtr(y[i]);
    printf("\n");
    return 0;
}
