#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int m = 3, n = 2;
double s = 0.;

double xx(double t)
{
    return (1. - s) * cos(m * t) * cos(n * t) + s * cos((m + n) * t);
}

double yy(double t)
{
    return (1. - s) * cos(m * t) * sin(n * t) + s * sin((m + n) * t);
}

int main(int argc, char *argv[])
{
    double t, dt = M_PI / 500., x0, y0, x1, y1, et;

    if(argc > 1) m = atoi(argv[1]);
    if(argc > 2) n = atoi(argv[2]);
	if(argc > 3) {
		s = atof(argv[3]);
		if(s < 0.) s = 0.;
		else if(s > 1.) s = 1.;
	}
	if(((m % 2) == 1) && ((n % 2) == 1)) et = M_PI;
	else et = 2 * M_PI;
    x0 = xx(0.); y0 = yy(0.);
    for(t = dt; t < et; t += dt) {
        x1 = xx(t);
		y1 = yy(t);
        printf("connect %f %f %f %f\n", x0, y0, x1, y1);
		x0 = x1; y0 = y1;
    }
    return 0;
}
