#include <stdio.h>
#include <stdlib.h>

#define MAXP 40
#define MAXO MAXP*MAXP

int a[MAXO * MAXO], p, q;

int pwmod(int j, int i, int q2)
{
	int k;

	for(k = 0; k < i; k++) {
		j *= q2;
		j %= p;
	}
	return j;
}

int main(int argc, char *argv[])
{
	int i, i2, j, j2, q2, r;

	if(argc < 3) {
		fprintf(stderr, "Two parameters are needed\n");
		return 0;
	}
	p = atoi(argv[1]);
	if(p >= MAXP) {
		fprintf(stderr, "%d > %d\n", p, MAXP - 1);
		return 0;
	}
	q = atoi(argv[2]);
	if(p <= q) {
		fprintf(stderr, "The first parameter must greater than the second\n");
		return 0;
	}
	/*
	if((p % q) != 1) {
		fprintf(stderr, "%d を %d で割った余りが 1 ではない。\n", p, q);
		return 0;
	}
	*/
	for(i = 2; i < p; i++) {
		for(r = i, j = 1; j < q; j++) {
			r *= i;
			r %= p;
			if(r == 1) break;
		}
		if(j == q-1) break;
	}
	if(i == p) {
		fprintf(stderr, "位数 %d の巡回群は位数 %d の巡回群に作用しない。\n", q, p);
		return 0;
	}
	q2 = i;
	/*
	for(i = 1; i <= q; i++) printf("%d ", pwmod(1, i, q2));
	printf("\n");
	*/
	for(i = 0; i < q; i++) {
		for(j = 0; j < p; j++) {
			for(i2 = 0; i2 < q; i2++) {
				for(j2 = 0; j2 < p; j2++) {
					printf("%d ", ((i + i2) % q) * p + (j2 + pwmod(j, i2, q2)) % p);
				}
			}
			printf("\n");
		}
	}
	return 0;
}
