#include <stdio.h>
#include <stdlib.h>

#define MAXN 2000

typedef struct mt {
	int a, b, c, d;
} MT;

MT mtx[MAXN];
int p = 3;

MT mtmul(MT A, MT B)
{
	MT C;

	C.a = (A.a * B.a + A.b * B.c) % p;
	C.b = (A.a * B.b + A.b * B.d) % p;
	C.c = (A.c * B.a + A.d * B.c) % p;
	C.d = (A.c * B.b + A.d * B.d) % p;
	return C;
}

void prmt(MT A)
{
	fprintf(stderr, "%d %d\n%d %d\n", A.a, A.b, A.c, A.d);
}

int alex(MT A, int l)
{
	int i;

	for(i = 0; i < l; i++) {
		if(A.a != mtx[i].a) continue;
		if(A.b != mtx[i].b) continue;
		if(A.c != mtx[i].c) continue;
		if(A.d != mtx[i].d) continue;
		return i;
	}
	return -1;
}
	
int main(int argc, char *argv[])
{
	int i, j, l = 3;

	if(argc > 1) p = atoi(argv[1]);
	mtx[0].a = mtx[0].d = 1; mtx[0].b = mtx[0].c = 0;
	mtx[1].a = mtx[1].b = mtx[1].d = 1; mtx[1].c = 0;
	mtx[2].a = mtx[2].c = mtx[2].d = 1; mtx[2].b = 0;
	if(argc > 2) {
		for(i = 2; i < p; i++, l++) {
			mtx[l].a = i; mtx[l].b = mtx[l].c = 0; mtx[l].d = 1;
		}
	}
	for(i = 1; i < l; i++) {
		for(j = 1; j <= i; j++) {
			mtx[l] = mtmul(mtx[i], mtx[j]);
			if(alex(mtx[l], l) < 0) {
				fprintf(stderr, "%d\n", l);
				prmt(mtx[l]);
				l++;
				if(l >= MAXN) return -1;
			}
			mtx[l] = mtmul(mtx[j], mtx[i]);
			if(alex(mtx[l], l) < 0) {
				fprintf(stderr, "%d\n", l);
				prmt(mtx[l]);
				l++;
				if(l >= MAXN) return -1;
			}
		}
	}
	for(i = 0; i < l; i++) {
		for(j = 0; j < l; j++) printf("%d ", alex(mtmul(mtx[j], mtx[i]), l));
		printf("\n");
	}
	return 0;
}
