#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int inv[4];
double ds = 0.01;

typedef struct {
    double r, i;
} CPX;

double abs(CPX z)
{
    return sqrt(z.r * z.r + z.i * z.i);
}

CPX operator +(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r + x1.r;
    y.i = x2.i + x1.i;
    return y;
}

CPX operator -(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r - x1.r;
    y.i = x2.i - x1.i;
    return y;
}

CPX operator +(CPX x2, double x1)
{
    CPX y;

    y.r = x2.r + x1;
    y.i = x2.i;
    return y;
}

CPX operator *(CPX x, CPX y)
{
    CPX z;

    z.r = x.r * y.r - x.i * y.i;
    z.i = x.r * y.i + x.i * y.r;
    return z;
}

CPX operator *(double x, CPX y)
{
    CPX z;

    z.r = x * y.r;
    z.i = x * y.i;
    return z;
}

CPX operator /(CPX x, double y)
{
    CPX z;

    z.r = x.r / y;
    z.i = x.i / y;
    return z;
}

CPX operator /(CPX x, CPX y)
{
    CPX z;
    double w;

    w = y.r * y.r + y.i * y.i;
    z.r = (x.r * y.r + x.i * y.i) / w;
    z.i = (x.i * y.r - x.r * y.i) / w;
    return z;
}

CPX operator /(double x, CPX y)
{
    CPX z;
    double w;

    w = y.r * y.r + y.i * y.i;
    z.r = x * y.r / w;
    z.i = - x * y.i / w;
    return z;
}

CPX conj(CPX z)
{
	CPX w;
	w.r = z.r;
	w.i = -z.i;
	return w;
}

CPX sqrtofcpx(CPX z)
{
	CPX w;
	double a, s;

	a = sqrt(abs(z));
	s = atan2(z.i, z.r) / 2;
	w.r = a * cos(s);
	w.i = a * sin(s);
	return w;
}

CPX rtofqd(CPX b, CPX c)
{
	CPX b2;

	b2.r = -b.r; b2.i = -b.i;
	return (b2 + sqrtofcpx(b * b - 4. * c)) / 2.;
}

typedef struct CR {
	CPX ct;
	double rd;
} Circle;

typedef struct MT {
	CPX a, b, c, d;
} mt;

mt T[4];

CPX mbtrp(mt T, CPX z) {
	return (T.a * z + T.b) / (T.c * z + T.d);
}

Circle mbtrcr(mt T, Circle c) {
	Circle d;
	CPX z;

	if(abs(T.d / T.c + c.ct) < 0.000000001) d.ct = T.a / T.c;
	else {
		z = c.ct - (c.rd * c.rd) / conj(T.d / T.c + c.ct);
		d.ct = mbtrp(T, z);
	}
	d.rd = abs(d.ct - mbtrp(T, c.ct + c.rd));
	return d;
}

mt mlmt(mt S, mt T)
{
	mt R;

	R.a = S.a * T.a + S.b * T.c;
	R.b = S.a * T.b + S.b * T.d;
	R.c = S.c * T.a + S.d * T.c;
	R.d = S.c * T.b + S.d * T.d;
	return R;
}

mt invmt(mt T)
{
	mt S;

	S.a.r = T.d.r; S.a.i = T.d.i; S.b.r = -T.b.r; S.b.i = -T.b.i;
	S.c.r = -T.c.r; S.c.i = -T.c.i; S.d.r = T.a.r; S.d.i = T.a.i;
	return S;
}


void WRITE(CPX z)
{
	//	printf("circle %f %f %f\n", c.ct.r, c.ct.i, c.rd);
	printf("disk %f %f %f\n", z.r, z.i, ds);
}

void ex(mt S, int j, int depth)
{
	int i;
	mt R;

	if(depth > 9) {
		WRITE(S.b / S.d);
		return;
	}
	depth++; 
	for(i = 0; i < 4; i++) {
		if(inv[i] == j) continue;
		ex(mlmt(S, T[i]), i, depth);
	}
}

int main(int argc, char *argv[])
{
	int i;
	CPX ta, tb, tab, z0, c2, c4, i2;

	if(argc > 1) ds = atof(argv[1]);
	/*
	T[0].a.r = 1.; T[0].d.r = 1.; T[0].b.r = 0.; T[0].c.r = 0.;
	T[0].a.i = T[0].b.i = T[0].d.i = 0; T[0].c.i = 2.;
	T[2].a.r = 1.; T[2].a.i = -1.; T[2].b.r = 1.; T[2].b.i = 0.;
	T[2].c.r = 1.; T[2].c.i = 0.; T[2].d.r = 1.; T[2].d.i = 1.;
	*/
	c2.r = 2.; c2.i = 0; c4 = 2. * c2;
	i2.r = 0; i2.i = 2.;
	ta.r = tb.r = 2.; ta.i = 0.2; tb.i = 0.2;
	tab = rtofqd(-1. * ta * tb, ta * ta + tb * tb);
	z0 = (tab - c2) * tb / (ta * tab - 2. * ta + i2 * tab);
	T[0].a = T[0].d = ta / 2.;
	T[0].b = (ta * tab - 2. * tb + 2. * i2) / ((2. * tab + c4) * z0);
	T[0].c = (ta * tab - 2. * tb - 2. * i2) * z0 / (2. * tab - c4);
	T[2].a = (tb - i2) / 2.; T[2].b = T[2].c = tb / 2.; T[2].d = (tb + i2) / 2.;
	T[1] = invmt(T[0]); T[3] = invmt(T[2]);
	inv[0] = 1; inv[1] = 0; inv[2] = 3; inv[3] = 2;
	for(i = 0; i < 4; i++) ex(T[i], i, 0);
	return 0;
}

