#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int inv[4];

typedef struct {
    double r, i;
} CPX;

double abs(CPX z)
{
    return sqrt(z.r * z.r + z.i * z.i);
}

CPX operator +(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r + x1.r;
    y.i = x2.i + x1.i;
    return y;
}

CPX operator -(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r - x1.r;
    y.i = x2.i - x1.i;
    return y;
}

CPX operator +(CPX x2, double x1)
{
    CPX y;

    y.r = x2.r + x1;
    y.i = x2.i;
    return y;
}

CPX operator *(CPX x, CPX y)
{
    CPX z;

    z.r = x.r * y.r - x.i * y.i;
    z.i = x.r * y.i + x.i * y.r;
    return z;
}

CPX operator /(CPX x, CPX y)
{
    CPX z;
    double w;

    w = y.r * y.r + y.i * y.i;
    z.r = (x.r * y.r + x.i * y.i) / w;
    z.i = (x.i * y.r - x.r * y.i) / w;
    return z;
}

CPX operator /(double x, CPX y)
{
    CPX z;
    double w;

    w = y.r * y.r + y.i * y.i;
    z.r = x * y.r / w;
    z.i = - x * y.i / w;
    return z;
}

CPX conj(CPX z)
{
	CPX w;
	w.r = z.r;
	w.i = -z.i;
	return w;
}

typedef struct CR {
	CPX ct;
	double rd;
} Circle;

Circle c[4];

typedef struct MT {
	CPX a, b, c, d;
} mt;

mt T[4];

CPX mbtrp(mt T, CPX z) {
	return (T.a * z + T.b) / (T.c * z + T.d);
}

Circle mbtrcr(mt T, Circle c) {
	Circle d;
	CPX z;

	if(abs(T.d / T.c + c.ct) < 0.000000001) d.ct = T.a / T.c;
	else {
		z = c.ct - (c.rd * c.rd) / conj(T.d / T.c + c.ct);
		d.ct = mbtrp(T, z);
	}
	d.rd = abs(d.ct - mbtrp(T, c.ct + c.rd));
	return d;
}

mt mlmt(mt S, mt T)
{
	mt R;

	R.a = S.a * T.a + S.b * T.c;
	R.b = S.a * T.b + S.b * T.d;
	R.c = S.c * T.a + S.d * T.c;
	R.d = S.c * T.b + S.d * T.d;
	return R;
}

mt invmt(mt T)
{
	mt S;

	S.a.r = T.d.r; S.a.i = T.d.i; S.b.r = -T.b.r; S.b.i = -T.b.i;
	S.c.r = -T.c.r; S.c.i = -T.c.i; S.d.r = T.a.r; S.d.i = T.a.i;
	return S;
}


void WRITE(Circle c)
{
	//	printf("circle %f %f %f\n", c.ct.r, c.ct.i, c.rd);
	printf("disk %f %f %f\n", c.ct.r, c.ct.i, c.rd);
}

void ex(mt S, int j, int depth)
{
	int i;
	mt R;

	if(depth == 0) printf("gray 0.8\n");
	else if(depth == 1) printf("gray 0.7\n");
	else if(depth == 2) printf("gray 0.6\n");
	else if(depth == 3) printf("gray 0.5\n");
	else if(depth == 4) printf("gray 0.4\n");
	else if(depth == 5) printf("gray 0.3\n");
	else if(depth == 6) printf("gray 0.2\n");
	else if(depth == 7) printf("gray 0.1\n");
	for(i = 0; i < 4; i++) {
		if(i != j) WRITE(mbtrcr(S, c[i]));
	}
	if(depth > 6) return;
	depth++; 
	for(i = 0; i < 4; i++) {
		if(inv[i] == j) continue;
		ex(mlmt(S, T[i]), i, depth);
	}
}

int main()
{
	int i;
	double st = 0.78, cst = cos(st), tst = tan(st);

	c[0].ct.r = 0.; c[0].ct.i = 100.; c[0].rd = 100.;
	c[2].ct.r = -1.; c[2].ct.i = -1.; c[2].rd = 1.;
	T[0].a.r = 1.; T[0].d.r = 1.; T[0].b.r = 0.; T[0].c.r = 0.;
	T[0].a.i = T[0].b.i = T[0].d.i = 0; T[0].c.i = 2.;
	T[2].a.r = 1.; T[2].a.i = -1.; T[2].b.r = 1.; T[2].b.i = 0.;
	T[2].c.r = 1.; T[2].c.i = 0.; T[2].d.r = 1.; T[2].d.i = 1.;
	T[1] = invmt(T[0]); T[3] = invmt(T[2]);
	c[1] = mbtrcr(T[0], c[0]);
	c[3] = mbtrcr(T[2], c[2]);
	//	printf("circle 0 0 1\n");
	printf("gray 0.9\n");
	for(i = 0; i < 4; i++) WRITE(c[i]);
	inv[0] = 1; inv[1] = 0; inv[2] = 3; inv[3] = 2;
	for(i = 0; i < 4; i++) ex(T[i], i, 0);
	return 0;
}

