#include <stdio.h>
#include <stdlib.h>

#define MDIM 3

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	   s = 0;
	   for(j = 0; j < m; j++) s += a[i * m + j] * b[j * n + k];
	   c[i * n + k] = s;
	}
    }
}

void display(int a[], int m, int n)
{
    int i, j;

    for(i = 0; i < m; i++) {
        for(j = 0; j < n; j++) printf("%d ", a[i * n + j]);
	printf("\n");
    }
}

int main(int argc, char *argv[])
{
    int i, j, k, w[8], a[MDIM * MDIM], b[MDIM * MDIM], a2[MDIM * MDIM], b2[MDIM * MDIM], a2b2[MDIM * MDIM], a12, a24, a68;

	if (argc < 8) {
		printf("8 parameters needed\n");
		exit(0);
	}
	for(i = 0; i < 8; i++) w[i] = atoi(argv[i + 1]);
	a12 = w[0] * w[1];
	a24 = w[1] * w[3];
	a[0] = w[0]; a[3] = w[3]; a[6] = -1;
	a[1] = a12 - 1; a[4] = a24 + w[2]; a[7] = -w[1];
	a[2] = w[0] * w[0] + w[3] * (a12 - 1); a[5] = w[3] * (a24 + w[2] + w[0]) - 1;
	a[8] = -w[0] - a24;
	display(a, 3, 3);
	printf("\n");
	a68 = w[5] * w[7];
	b[0] = w[6] + a68; b[3] = -w[5]; b[6] = w[4] * w[5] - 1;
	b[1] = w[7] * (w[4] + w[6] + a68) - 1; b[4] = -w[4] - a68; b[7] = w[4] * (w[4] + a68) -w[7];
	b[2] = w[7]; b[5] = -1; b[8] = w[4];
	display(b, 3, 3);
	printf("\n");
	mtxmul(a, a, a2, 3, 3, 3);
	mtxmul(b, b, b2, 3, 3, 3);
	mtxmul(a2, b2, a2b2, 3, 3, 3);
	display(a2b2, 3, 3);
	return 0;
}
