/*
ol3r n : 位数 n の環 R の和と積の演算表を読み込んで OL(3, R) の演算表を出力
 */
#include <stdio.h>
#include <stdlib.h>

#define MAXL 20000
#define MAXO 100

int sum[MAXO * MAXO], mul[MAXO * MAXO], inv[MAXO], x[MAXL], n, m = 0;

void itom(int a, int m[])
{
	int i;

	for(i = 0; i < 9; i++) {
		m[i] = a % n;
		a /= n;
	}
}

int mtoi(int m[])
{
	int i, h = 0;

	for(i = 8; i >= 0; i--) {
		h *= n;
		h += m[i];
	}
	return h;
}

int isort(int m[])
{
	int i, j, k, s;

	for(i = 0; i < 3; i++) {
		for(j = 0; j < 3; j++) {
			for(s = k = 0; k < 3; k++) s = sum[s * n + mul[m[k * 3 + i] * n + m[k * 3 + j]]];
			if((i == j) && (s != 1)) return -1;
			if((i != j) && (s != 0)) return -1;
		}
	}
	return 1;
}

int mtmul(int i, int j)
{
	int k, l, h, a[9], b[9], c[9];

	itom(i, a);
	itom(j, b);
	for(k = 0; k < 3; k++) {
		for(l = 0; l < 3; l++) {
			int s = 0;
			for(h = 0; h < 3; h++) s = sum[s * n + mul[a[k * 3 + h] * n + b[h * 3 + l]]];
			c[k * 3 + l] = s;
		}
	}
	h = mtoi(c);
	for(k = 0; k < m; k++) if(x[k] == h) return k;
	//	disp(c);
	return -1;
}

void disp(int m[])
{
	int i;

	for(i = 0; i < 9; i++) {
		fprintf(stderr, "%d ", m[i]);
		if(((i + 1) % 3) == 0) fprintf(stderr, "\n");
	}
}

int main(int argc, char *argv[])
{
	int i, j, n4, n8, n9, u, mt[9];

	if(argc < 2) {
		fprintf(stderr, "One parameter needed\n");
		return 0;
	}
	n = atoi(argv[1]);
	if(n > MAXO || n < 2) return 0;
	for(i = 0; i < n * n; i++) scanf("%d", sum + i);
	for(i = 0; i < n; i++) mul[i] = mul[i * n] = 0;
	for(i = 1; i < n; i++) {
		for(j = 1; j < n; j++) scanf("%d", mul + i * n + j);
	}
	n4 = n * n * n * n; n8 = n4 * n4; n9 = n8 * n;
	u = n8 + n4 + 1;
	x[m++] = u;
	itom(u, mt);
	disp(mt);
	for(i = 0; i < n9; i++) {
		if(i == u) continue;
		itom(i, mt);
		if(isort(mt) > 0) {
			fprintf(stderr, "%d(%d)\n", m, mtoi(mt));
			disp(mt);
			x[m++] = i;
		}
	}
	for(i = 0; i < m; i++) {
		for(j = 0; j < m; j++) printf("%d ", mtmul(x[i], x[j]));
		printf("\n");
	}
	return 0;
}
