#include <stdio.h>
#include <stdlib.h>
#include "spacegeometry.h"

POINT ortho(POINT a, POINT b, POINT c)
{
	double s, t, u, d, a11, a12, a13, a21, a22, a23, x11, x12, x13, x22, x23, x33;
	POINT v;
	x11 = a * a; x12 = a * b; x13 = a * c; x22 = b * b; x23 = b * c; x33 = c * c;
	a11 = x12 - x13; a12 = x22 - x23; a13 = x23 - x33;
	a21 = x13 - x11; a22 = x23 - x12; a23 = x33 - x13;
	d = a11 * a22 + a12 * a23 + a13 * a21 - a11 * a23 - a22 * a13 - a12 * a21;
	s = (a11 * a22 + a12 * a23 + a13 * a22 - a11 * a23 - a22 * a13 - a12 * a22) / d;
	t = (a11 * a22 + a11 * a23 + a13 * a21 - a11 * a23 - a22 * a13 - a11 * a21) / d;
	u = (a11 * a22 + a12 * a22 + a11 * a21 - a11 * a22 - a22 * a11 - a12 * a21) / d;
	v.x = s * a.x + t * b.x + u * c.x;
	v.y = s * a.y + t * b.y + u * c.y;
	v.z = s * a.z + t * b.z + u * c.z;
	printf("x11 = %f, x12 = %f, x13 = %f, x22 = %f, x23 = %f, x33 = %f\n", x11, x12, x13, x22, x23, x33);
	printf("s = %f, t = %f, u = %f\n", s, t, u);
	return v;
}


int main(int argc, char *argv[])
{
	POINT a, b, c, v;

	if(argc < 10) return 0;
	a.x = atof(argv[1]);
	a.y = atof(argv[2]);
	a.z = atof(argv[3]);
	b.x = atof(argv[4]);
	b.y = atof(argv[5]);
	b.z = atof(argv[6]);
	c.x = atof(argv[7]);
	c.y = atof(argv[8]);
	c.z = atof(argv[9]);
	v = ortho(a, b, c);
	printf("(%f, %f, %f)\n", v.x, v.y, v.z);
	return 0;
}

