#include <stdio.h>
#include <stdlib.h>
#include "spacegeometry.h"

Plane pl3pts(POINT a, POINT b, POINT c)
{
	Plane h;

	h.a = a.y * b.z + b.y * c.z + c.y * a.z - a.y * c.z - b.y * a.z - c.y * b.z;
	h.b = a.z * b.x + b.z * c.x + c.z * a.x - a.z * c.x - b.z * a.x - c.z * b.x;
	h.c = a.x * b.y + b.x * c.y + c.x * a.y - a.x * c.y - b.x * a.y - c.x * b.y;
	h.d = a.x * b.y * c.z + b.x * c.y * a.z + c.x * a.y * b.z - a.x * c.y * b.z - b.x * a.y * c.z - c.x * b.y * a.z;
	return h;
}

int main(int argc, char *argv[])
{
	POINT a, b, c;
	Plane h;

	if(argc < 10) return 0;
	a.x = atof(argv[1]);
	a.y = atof(argv[2]);
	a.z = atof(argv[3]);
	b.x = atof(argv[4]);
	b.y = atof(argv[5]);
	b.z = atof(argv[6]);
	c.x = atof(argv[7]);
	c.y = atof(argv[8]);
	c.z = atof(argv[9]);
	h = pl3pts(a, b, c);
	printf("%fx + %fy + %fz = %f\n", h.a, h.b, h.c, h.d);
	return 0;
}
