#include <stdio.h>
#include <stdlib.h>

typedef struct line {
    double a, b, c;
} LINE;

typedef struct pointin2d {
    double x, y;
} POINT;

typedef struct circle {
    POINT c;
    double r;
} CIRC;

typedef struct arc {
    POINT c;
    double r, as, ae;
} ARC;

void READ(POINT *p);

void READ(LINE *l);

void READ(CIRC *c);

void WRITE(CIRC c);

void WRITE(LINE l);

void WRITE2(CIRC c);

void WRITE(POINT p, POINT q, POINT r);

void WRITE(POINT p, POINT q);

void WRITE(POINT p);

LINE operator *(CIRC c, CIRC d);
// c と d の交点を通る直線

LINE operator |(POINT p, POINT q);
// p と q を結ぶ線分の垂直二等分線

LINE operator |(POINT p, LINE l);
// p から l への垂線

LINE operator /(POINT p, LINE l);
// p を通って l に平行な直線

POINT operator %(POINT p, POINT q);
// p と q を結ぶ線分の中点

POINT operator *(LINE l1, LINE l2);
// l1 と l2 の交点

POINT operator %(POINT p, LINE l);

LINE operator *(POINT p, POINT q);
// p と q を通る直線

POINT operator |(CIRC c, POINT P);

CIRC operator -(CIRC c1, CIRC c2);

POINT operator &(CIRC c1, CIRC c2);

CIRC operator -(POINT P, POINT Q);

double operator +(POINT p, POINT q);
// p と q の距離

double operator +(POINT p, LINE l);
// p と l の距離

int operator +(CIRC c1, CIRC c2);

CIRC circumscrl(POINT p, POINT q, POINT r);
/*
CIRC circumscrl2(LINE l, LINE m, LINE n);
CIRC inscribedcrl(POINT p[]);
CIRC escribedcrl(POINT p[]);
POINT orthocenter(POINT p[]);
*/

CIRC Pline2(POINT P, POINT z);

void Pconnect(POINT P, POINT Q);

int divide(POINT P, POINT Q, int n, POINT R[]);
