#include <stdio.h>
#include <stdlib.h>

#define MDIM 6

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	   s = 0;
	   for(j = 0; j < m; j++) s += a[i * l + j] * b[j * n + k];
	   c[i * l + k] = s;
	}
    }
}

void display(int a[], int m, int n)
{
    int i, j;

    for(i = 0; i < m; i++) {
        for(j = 0; j < n; j++) printf("%d ", a[i * m + j]);
	printf("\n");
    }
}

int main(int argc, char *argv[])
{
    int i, j, k, a[MDIM * MDIM], b[MDIM * MDIM], c[MDIM * MDIM], *pa, n, l;

    if(argc == 1) {
        fprintf(stderr, "one parameter needed\n");
		return 0;
    }
    n = atoi(argv[1]);
    if(n < 2 || n > MDIM) return 0;
	if(argc > 2) l = atoi(argv[2]);
	else l = 8;
    pa = a;
    for(i = 0; i < n; i++) {
        for(j = 0; j < n; j++) scanf("%d", pa++ );
    }
    mtxmul(a, a, b, n, n, n);
    display(b, n, n);
    for(i = 3; i < l; i++) {
        printf("%d:\n", i);
		mtxmul(a, b, c, n, n, n);
		display(c, n, n);
		for(j = 0; j < n * n; j++) b[j] = c[j];
    }
    return 0;
}
