#include <stdio.h>
#include <stdlib.h>

#define MDIM 7

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	   s = 0;
	   for(j = 0; j < m; j++) s += a[i * m + j] * b[j * n + k];
	   c[i * n + k] = s;
	}
    }
}

void display(int a[], int m, int n)
{
    int i, j;

    for(i = 0; i < m; i++) {
        for(j = 0; j < n; j++) printf("%d ", a[i * n + j]);
	printf("\n");
    }
}

main(int argc, char *argv[])
{
    int i, j, k, a[MDIM * MDIM], b[MDIM * MDIM], c[MDIM * MDIM], *pa, l, m, n;

    if(argc < 4) {
        fprintf(stderr, "Three parameter needed\n");
	exit(0);
    }
    l = atoi(argv[1]);
    m = atoi(argv[2]);
    n = atoi(argv[3]);
    pa = a;
    for(i = 0; i < l; i++) {
        for(j = 0; j < m; j++) scanf("%d", pa++ );
    }
    pa = b;
    for(i = 0; i < m; i++) {
        for(j = 0; j < n; j++) scanf("%d", pa++ );
    }
    mtxmul(a, b, c, l, m, n);
    display(c, l, n);
    return 0;
}

