#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DIM 3
#define MD 15

void ex(double e1[DIM], double e2[DIM], double e3[DIM], int dr, int depth)
{
    double f[DIM], x1[2], x2[2], x3[2]; 
    int i;

    if(depth++ == MD) return;
	for(i = 0; i < 2; i++) {
		x1[i] = e1[i] / e1[2];
		x2[i] = e2[i] / e2[2];
		x3[i] = e3[i] / e3[2];
	}
    printf("connect %f %f %f %f %f %f %f %f\n", x1[0], x1[1], x2[0], x2[1], x3[0], x3[1], x1[0], x1[1]);
	if(dr == 0) printf("color 3 0 0\nconnect %f %f %f %f\ngray 0\n", x1[0], x1[1], x2[0], x2[1]);
	for(i = 0; i < DIM; i++) f[i] = e2[i] + 2 * e3[i] - e1[i];
	ex(e2, f, e3, (dr + 1) % 2, depth);
	if(dr == 0) return;
	for(i = 0; i < DIM; i++) f[i] = e1[i] + e2[i] - e3[i];
	ex(e2, e1, f, dr, depth);
}

main()
{
    int i;
    double e1[DIM], e2[DIM], e3[DIM];

    e1[1] = e3[0] = e3[1] = 0;
    e1[0] = e2[0] = e2[1] = e3[2] = 1;
	e1[2] = e2[2] = 2.;
	e2[0] = .5; e2[1] = .5 * sqrt(3.);
    ex(e1, e2, e3, 1, 0);
	//	printf("color 3 0 0\ndisk .4 .2666 .005\ndisk .266 .4 .005\ndisk .333 .333 .005\n");
    return 0;
}
