#include <stdio.h>
#include <stdlib.h>

#define MAXP 100

int n, m;

int sum(int i, int j)
{
	int i1, i2, j1, j2;

	i1 = i % n; i2 = i / n;
	j1 = j % n; j2 = j / n;
	return ((i2 + j2) % m) * n + (i1 + j1) % n;
}
int mul(int i, int j)
{
	int i1, i2, j1, j2;

	i1 = i % n; i2 = i / n;
	j1 = j % n; j2 = j / n;
	return ((i2 * j1 + j2 * i1) % m) * n + (i1 * j1) % n;
}

int main(int argc, char *argv[])
{
	int i, j;

	if(argc < 3) {
		fprintf(stderr, "Two parameters needed\n");
		return 0;
	}
	n = atoi(argv[1]);
	m = atoi(argv[2]);
	if((n < 3) || (n > MAXP)) return 0;
	if((n % m) != 0) {
		fprintf(stderr, "%d/%d is not a integer\n", n, m);
		return 0;
	}
	for(i = 0; i < m * n; i++) {
			for(j = 0; j < m * n; j++) printf("%d ", sum(i, j));
		printf("\n");
	}
	for(i = 1; i < m * n; i++) {
		for(j = 1; j < m * n; j++) printf("%d ", mul(i, j));
		printf("\n");
	}
	return 0;
}
