#include <stdio.h>
#include <stdlib.h>
#include <math.h>


typedef struct {
    double r, i;
} CPX;

double abs(CPX z)
{
    return sqrt(z.r * z.r + z.i * z.i);
}

CPX operator +(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r + x1.r;
    y.i = x2.i + x1.i;
    return y;
}

CPX operator -(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r - x1.r;
    y.i = x2.i - x1.i;
    return y;
}

CPX operator /(CPX x, double y)
{
    CPX z;

    z.r = x.r / y;
    z.i = x.i / y;
    return z;
}

CPX operator *(CPX x, CPX y)
{
    CPX z;

    z.r = x.r * y.r - x.i * y.i;
    z.i = x.r * y.i + x.i * y.r;
    return z;
}

CPX operator *(double x, CPX y)
{
    CPX z;

    z.r = x * y.r;
    z.i = x * y.i;
    return z;
}

CPX sqrtofcpx(CPX z)
{
	CPX w;
	double a, s;

	a = sqrt(abs(z));
	s = atan2(z.i, z.r) / 2;
	w.r = a * cos(s);
	w.i = a * sin(s);
	return w;
}

CPX rtofqd(CPX b, CPX c)
{
	CPX b2;

	b2.r = -b.r; b2.i = -b.i;
	return (b2 - sqrtofcpx(b * b - 4. * c)) / 2.;
}

int main(int argc, char *argv[])
{
	CPX b, c, z, w;

	if(argc < 5) return -1;
	b.r = atof(argv[1]);
	b.i = atof(argv[2]);
	c.r = atof(argv[3]);
	c.i = atof(argv[4]);
	z = rtofqd(b, c);
	w = z * z + b * z + c;
	printf("%f +i%f, %f+i%f\n", z.r, z.i, w.r, w.i);
	return 0;
}
