#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "spacegeometry.h"

POINT isof3pl(Plane u, Plane v, Plane w)
{
	POINT p;
	double d;

	d = u.a * v.b * w.c + u.b * v.c * w.a + u.c * v.a * w.b - u.a * v.c * w.b - u.c * v.b * w.a - u.b * v.a * w.c;
	p.x = (u.d * v.b * w.c + u.b * v.c * w.d + u.c * v.d * w.b - u.d * v.c * w.b - u.c * v.b * w.d - u.b * v.d * w.c) / d;
	p.y = (u.a * v.d * w.c + u.d * v.c * w.a + u.c * v.a * w.d - u.a * v.c * w.d - u.c * v.d * w.a - u.d * v.a * w.c) / d;
	p.z = (u.a * v.b * w.d + u.b * v.d * w.a + u.d * v.a * w.b - u.a * v.d * w.b - u.d * v.b * w.a - u.b * v.a * w.d) / d;
	return p;
}

Plane pl3pts(POINT a, POINT b, POINT c)
{
	Plane h;

	h.a = a.y * b.z + b.y * c.z + c.y * a.z - a.y * c.z - b.y * a.z - c.y * b.z;
	h.b = a.z * b.x + b.z * c.x + c.z * a.x - a.z * c.x - b.z * a.x - c.z * b.x;
	h.c = a.x * b.y + b.x * c.y + c.x * a.y - a.x * c.y - b.x * a.y - c.x * b.y;
	h.d = a.x * b.y * c.z + b.x * c.y * a.z + c.x * a.y * b.z - a.x * c.y * b.z - b.x * a.y * c.z - c.x * b.y * a.z;
	return h;
}

POINT circumct(POINT p, POINT q, POINT r)
{
	Plane u, v, w;

	u = pl3pts(p, q, r);
	/*
	v.a = p.x - q.x; v.b = p.y - q.y; v.c = p.z - q.z;
	v.d = (p.x * p.x - q.x * q.x + p.y * p.y - q.y * q.y + p.z * p.z - q.z * q.z) / 2.;
	w.a = p.x - r.x; w.b = p.y - r.y; w.c = p.z - r.z;
	w.d = (p.x * p.x - r.x * r.x + p.y * p.y - r.y * r.y + p.z * p.z - r.z * r.z) / 2.;
	*/
	v = p | q;
	w = p | r;
	return isof3pl(u, v, w);
}

POINT nv(POINT a, POINT b, POINT c)
{
	POINT h;

	h.x = a.y * b.z + b.y * c.z + c.y * a.z - a.y * c.z - b.y * a.z - c.y * b.z;
	h.y = a.z * b.x + b.z * c.x + c.z * a.x - a.z * c.x - b.z * a.x - c.z * b.x;
	h.z = a.x * b.y + b.x * c.y + c.x * a.y - a.x * c.y - b.x * a.y - c.x * b.y;
	return h;
}

int main(int argc, char *argv[])
{
	POINT a, b, c, d, e, f, g, f0, f1, h, h0, h1;

	a.x = a.y = a.z = g.x = g.y = 0.;
	g.z = 1.;
	c.x = 0.25; d.x = -.25; c.y = d.y = sqrt(11.) / 4.; c.z = d.z = 0.5;
	b.x = b.z = e.z = 0.5; e.x = -0.5;
	b.y = e.y = (sqrt(11.) - sqrt(7.)) / 4.;
	f0 = circumct(a, b, c);
	f1 = nv(a, b, c);
	if((f1 * (e - f0)) < 0) f1 = -1. * f1;
	f = f0 + sqrt((1. - (a - f0) * (a - f0)) / (f1 * f1)) * f1;
	h0 = circumct(a, d, e);
	h1 = nv(a, d, e);
	if((f1 * (b - f0)) < 0) h1 = -1. * h1;
	h = h0 + sqrt((1. - (a - h0) * (a - h0)) / (h1 * h1)) * h1;
	printf("AG = %f, AC = %f, CG = %f, DG = %f\n", (a - g) * (a - g), (a - c) * (a - c), (c - g) * (c - g), (d - g) * (d - g));
	printf("AB = %f, BG = %f, BD = %f, BE = %f, BC = %f\n", (a - b) * (a - b), (b - g) * (b - g), (b - d) * (b - d), (b - e) * (b - e), (b - c) * (b - c));
	printf("F = (%f, %f, %f), H = (%f, %f, %f)\n", f.x, f.y, f.z, h.x, h.y, h.z);
	printf("AF = %f, BF = %f, CF = %f, DF = %f, EF = %f, GF = %f\n", (f - a) * (f - a), (b - f) * (b - f), (c - f) * (c - f), (d - f) * (d - f), (e - f) * (e - f), (g - f) * (g - f));
	printf("FH = %f, CE = %f\n", (f - h) * (f - h), (c - e) * (c - e));
	return 0;
}

	
