#include <stdio.h>

#define DP 5

int g1[9], g2[9], g3[9], s[9];

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	    s = 0;
	    for(j = 0; j < m; j++) s += a[i * m + j] * b[j * n + k];
	    c[i * n + k] = s;
	}
    }
}

void draw(int s[])
{
    double x1, x2, x3, y1, y2, y3;

    x1 = (double) s[0] / (double) s[6];
    y1 = (double) s[3] / (double) s[6];
    x2 = (double) s[1] / (double) s[7];
    y2 = (double) s[4] / (double) s[7];
    x3 = (double) s[2] / (double) s[8];
    y3 = (double) s[5] / (double) s[8];
    printf("gray 0\nconnect %f %f %f %f\n", x1, y1, x2, y2);
    printf("color 0 0 3\nconnect %f %f %f %f\n", x2, y2, x3, y3);
    printf("color 3 0 0\nconnect %f %f %f %f\n", x1, y1, x3, y3);
    return;
}

void ex(int s[], int depth, int e)
{
    int t[9];

    if(depth == 8) return;
    depth++;
    if(e != 1) {
          mtxmul(g1, s, t, 3, 3, 3);
	  draw(t);
	  ex(t, depth, 1);
    }
    if(e != 2) {
          mtxmul(g2, s, t, 3, 3, 3);
	  draw(t);
	  ex(t, depth, 2);
    }
    if(e != 3) {
          mtxmul(g3, s, t, 3, 3, 3);
	  draw(t);
	  ex(t, depth, 3);
    }
}

main()
{
    int t[9];

    s[0] = s[4] = s[6] = s[7] = s[8] = 1;
    s[1] = s[3] = s[5] = 0;
    s[2] = -1;
    g1[0] = g1[4] = -1;
    g1[1] = g1[2] = g1[3] = g1[5] = g1[6] = 0;
    g1[7] = g1[8] = 1;
    g2[0] = g2[4] = -1;
    g2[1] = g2[3] = g2[6] = g2[7] = 0;
    g2[2] = g2[5] = g2[8] = 1;
    g3[0] = g3[2] = g3[4] = g3[7] = -2;
    g3[1] = g3[3] = 1;
    g3[5] = g3[6] = 2;
    g3[8] = 3;
    //    draw(s);
    mtxmul(g1, s, t, 3, 3, 3);
    draw(t);
    ex(s, 0, 1);
    mtxmul(g2, s, t, 3, 3, 3);
    draw(t);
    ex(s, 0, 2);
    mtxmul(g3, s, t, 3, 3, 3);
    draw(t);
    ex(s, 0, 3);
    return 0;
}
